package com.feasycom.feasywifi

import android.annotation.SuppressLint
import android.app.Application
import android.content.Context
import cat.ereza.customactivityoncrash.config.CaocConfig
import com.feasycom.feasywifi.ui.CrashActivity
import com.feasycom.feasywifi.ui.MainActivity

class App: Application() {

    override fun onCreate() {
        super.onCreate()
        sContext = applicationContext
        // Crash 捕捉界面
        CaocConfig.Builder.create()
            .backgroundMode(CaocConfig.BACKGROUND_MODE_SHOW_CUSTOM)
            .enabled(true)
            .trackActivities(true)
            .minTimeBetweenCrashesMs(2000) // 重启的 Activity
            .restartActivity(MainActivity::class.java) // 错误的 Activity
            .errorActivity(CrashActivity::class.java) // 设置监听器
            //.eventListener(new YourCustomEventListener())
            .apply()
    }

    companion object{
        @SuppressLint("StaticFieldLeak")
        var sContext: Context? = null
    }
}