/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SafeVarargs
    public static <E> List<E> newUnmodifiableList(E ... array) {
        return Collections.unmodifiableList(CollectionUtils.newArrayList(array));
    }

    @SafeVarargs
    public static <E> List<E> newUnmodifiableListNotNull(E ... array) {
        return Collections.unmodifiableList(CollectionUtils.newArrayListNotNull(array));
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... array) {
        ArrayList<E> list = new ArrayList<E>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (E e : array) {
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayListNotNull(E ... array) {
        ArrayList<E> list = new ArrayList<E>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (E e : array) {
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <E> LinkedList<E> newLinkedList(E ... array) {
        LinkedList<E> list = new LinkedList<E>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (E e : array) {
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <E> LinkedList<E> newLinkedListNotNull(E ... array) {
        LinkedList<E> list = new LinkedList<E>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (E e : array) {
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... array) {
        HashSet<E> set = new HashSet<E>();
        if (array == null || array.length == 0) {
            return set;
        }
        for (E e : array) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSetNotNull(E ... array) {
        HashSet<E> set = new HashSet<E>();
        if (array == null || array.length == 0) {
            return set;
        }
        for (E e : array) {
            if (e == null) continue;
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <E> TreeSet<E> newTreeSet(Comparator<E> comparator, E ... array) {
        TreeSet<E> set = new TreeSet<E>(comparator);
        if (array == null || array.length == 0) {
            return set;
        }
        for (E e : array) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <E> TreeSet<E> newTreeSetNotNull(Comparator<E> comparator, E ... array) {
        TreeSet<E> set = new TreeSet<E>(comparator);
        if (array == null || array.length == 0) {
            return set;
        }
        for (E e : array) {
            if (e == null) continue;
            set.add(e);
        }
        return set;
    }

    public static Collection newSynchronizedCollection(Collection collection) {
        return Collections.synchronizedCollection(collection);
    }

    public static Collection newUnmodifiableCollection(Collection collection) {
        return Collections.unmodifiableCollection(collection);
    }

    public static Collection union(Collection a, Collection b) {
        if (a == null && b == null) {
            return new ArrayList();
        }
        if (a == null) {
            return new ArrayList(b);
        }
        if (b == null) {
            return new ArrayList(a);
        }
        ArrayList list = new ArrayList();
        Map<Object, Integer> mapA = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapB = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionUtils.getFreq(obj, mapA), CollectionUtils.getFreq(obj, mapB));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection intersection(Collection a, Collection b) {
        if (a == null || b == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        Map<Object, Integer> mapA = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapB = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.min(CollectionUtils.getFreq(obj, mapA), CollectionUtils.getFreq(obj, mapB));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    private static int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static Collection disjunction(Collection a, Collection b) {
        if (a == null && b == null) {
            return new ArrayList();
        }
        if (a == null) {
            return new ArrayList(b);
        }
        if (b == null) {
            return new ArrayList(a);
        }
        ArrayList list = new ArrayList();
        Map<Object, Integer> mapA = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapB = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionUtils.getFreq(obj, mapA), CollectionUtils.getFreq(obj, mapB)) - Math.min(CollectionUtils.getFreq(obj, mapA), CollectionUtils.getFreq(obj, mapB));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection subtract(Collection a, Collection b) {
        if (a == null) {
            return new ArrayList();
        }
        if (b == null) {
            return new ArrayList(a);
        }
        ArrayList list = new ArrayList(a);
        for (Object o : b) {
            list.remove(o);
        }
        return list;
    }

    public static boolean containsAny(Collection coll1, Collection coll2) {
        if (coll1 == null || coll2 == null) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object o : coll1) {
                if (!coll2.contains(o)) continue;
                return true;
            }
        } else {
            for (Object o : coll2) {
                if (!coll1.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Object, Integer> getCardinalityMap(Collection coll) {
        HashMap<Object, Integer> count = new HashMap<Object, Integer>();
        if (coll == null) {
            return count;
        }
        for (Object obj : coll) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, 1);
                continue;
            }
            count.put(obj, c + 1);
        }
        return count;
    }

    public static boolean isSubCollection(Collection a, Collection b) {
        if (a == null || b == null) {
            return false;
        }
        Map<Object, Integer> mapA = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapB = CollectionUtils.getCardinalityMap(b);
        for (Object obj : a) {
            if (CollectionUtils.getFreq(obj, mapA) <= CollectionUtils.getFreq(obj, mapB)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection a, Collection b) {
        if (a == null || b == null) {
            return false;
        }
        return a.size() < b.size() && CollectionUtils.isSubCollection(a, b);
    }

    public static boolean isEqualCollection(Collection a, Collection b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Map<Object, Integer> mapA = CollectionUtils.getCardinalityMap(a);
        Map<Object, Integer> mapB = CollectionUtils.getCardinalityMap(b);
        if (mapA.size() != mapB.size()) {
            return false;
        }
        for (Object obj : mapA.keySet()) {
            if (CollectionUtils.getFreq(obj, mapA) == CollectionUtils.getFreq(obj, mapB)) continue;
            return false;
        }
        return true;
    }

    public static <E> int cardinality(E obj, Collection<E> coll) {
        if (coll == null) {
            return 0;
        }
        if (coll instanceof Set) {
            return coll.contains(obj) ? 1 : 0;
        }
        int count = 0;
        if (obj == null) {
            for (E e : coll) {
                if (e != null) continue;
                ++count;
            }
        } else {
            for (E e : coll) {
                if (!obj.equals(e)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <E> E find(Collection<E> collection, Predicate<E> predicate) {
        if (collection == null || predicate == null) {
            return null;
        }
        for (E item : collection) {
            if (!predicate.evaluate(item)) continue;
            return item;
        }
        return null;
    }

    public static <E> void forAllDo(Collection<E> collection, Closure<E> closure) {
        if (collection == null || closure == null) {
            return;
        }
        int index = 0;
        for (E e : collection) {
            closure.execute(index++, e);
        }
    }

    public static <E> void filter(Collection<E> collection, Predicate<E> predicate) {
        if (collection == null || predicate == null) {
            return;
        }
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            if (predicate.evaluate(it.next())) continue;
            it.remove();
        }
    }

    public static <E> Collection<E> select(Collection<E> inputCollection, Predicate<E> predicate) {
        if (inputCollection == null || predicate == null) {
            return new ArrayList();
        }
        ArrayList<E> answer = new ArrayList<E>(inputCollection.size());
        for (E o : inputCollection) {
            if (!predicate.evaluate(o)) continue;
            answer.add(o);
        }
        return answer;
    }

    public static <E> Collection<E> selectRejected(Collection<E> inputCollection, Predicate<E> predicate) {
        if (inputCollection == null || predicate == null) {
            return new ArrayList();
        }
        ArrayList<E> answer = new ArrayList<E>(inputCollection.size());
        for (E o : inputCollection) {
            if (predicate.evaluate(o)) continue;
            answer.add(o);
        }
        return answer;
    }

    public static <E1, E2> void transform(Collection<E1> collection, Transformer<E1, E2> transformer) {
        if (collection == null || transformer == null) {
            return;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            ListIterator<E2> it = list.listIterator();
            while (it.hasNext()) {
                it.set(transformer.transform(it.next()));
            }
        } else {
            Collection<E2> resultCollection = CollectionUtils.collect(collection, transformer);
            collection.clear();
            collection.addAll(resultCollection);
        }
    }

    public static <E1, E2> Collection<E2> collect(Collection<E1> inputCollection, Transformer<E1, E2> transformer) {
        ArrayList<E2> answer = new ArrayList<E2>();
        if (inputCollection == null || transformer == null) {
            return answer;
        }
        for (E1 e1 : inputCollection) {
            answer.add(transformer.transform(e1));
        }
        return answer;
    }

    public static <E> int countMatches(Collection<E> collection, Predicate<E> predicate) {
        if (collection == null || predicate == null) {
            return 0;
        }
        int count = 0;
        for (E o : collection) {
            if (!predicate.evaluate(o)) continue;
            ++count;
        }
        return count;
    }

    public static <E> boolean exists(Collection<E> collection, Predicate<E> predicate) {
        if (collection == null || predicate == null) {
            return false;
        }
        for (E o : collection) {
            if (!predicate.evaluate(o)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean addIgnoreNull(Collection<E> collection, E object) {
        if (collection == null) {
            return false;
        }
        return object != null && collection.add(object);
    }

    public static <E> void addAll(Collection<E> collection, Iterator<E> iterator) {
        if (collection == null || iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static <E> void addAll(Collection<E> collection, Enumeration<E> enumeration) {
        if (collection == null || enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static <E> void addAll(Collection<E> collection, E[] elements) {
        if (collection == null || elements == null || elements.length == 0) {
            return;
        }
        collection.addAll(Arrays.asList(elements));
    }

    public static Object get(Object object, int index) {
        if (object == null) {
            return null;
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionUtils.get(iterator, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionUtils.get(iterator, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        if (object == null) {
            return 0;
        }
        int total = 0;
        if (object instanceof Map) {
            total = ((Map)object).size();
        } else if (object instanceof Collection) {
            total = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            total = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                ++total;
                it.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
        } else {
            try {
                total = Array.getLength(object);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return total;
    }

    public static boolean sizeIsEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Iterator) {
            return !((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        try {
            return Array.getLength(object) == 0;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.size() == 0;
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static <E> Collection<E> retainAll(Collection<E> collection, Collection<E> retain) {
        if (collection == null || retain == null) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E item : collection) {
            if (!retain.contains(item)) continue;
            list.add(item);
        }
        return list;
    }

    public static <E> Collection<E> removeAll(Collection<E> collection, Collection<E> remove) {
        if (collection == null) {
            return new ArrayList();
        }
        if (remove == null) {
            return new ArrayList<E>(collection);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E obj : collection) {
            if (remove.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static <T> void shuffle(List<T> list) {
        Collections.shuffle(list);
    }

    public static String toString(Collection collection) {
        if (collection == null) {
            return "null";
        }
        return collection.toString();
    }

    public static interface Predicate<E> {
        public boolean evaluate(E var1);
    }

    public static interface Transformer<E1, E2> {
        public E2 transform(E1 var1);
    }

    public static interface Closure<E> {
        public void execute(int var1, E var2);
    }
}

