/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.blankj.utilcode.R;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public final class ToastUtils {
    private static final String TAG_TOAST = "TAG_TOAST";
    private static final int COLOR_DEFAULT = -16777217;
    private static final String NULL = "toast null";
    private static final String NOTHING = "toast nothing";
    private static final ToastUtils DEFAULT_MAKER = ToastUtils.make();
    private static WeakReference<IToast> sWeakToast;
    private String mMode;
    private int mGravity = -1;
    private int mXOffset = -1;
    private int mYOffset = -1;
    private int mBgColor = -16777217;
    private int mBgResource = -1;
    private int mTextColor = -16777217;
    private int mTextSize = -1;
    private boolean isLong = false;
    private Drawable[] mIcons = new Drawable[4];
    private boolean isNotUseSystemToast = false;

    @NonNull
    public static ToastUtils make() {
        return new ToastUtils();
    }

    @NonNull
    public final ToastUtils setMode(String mode) {
        this.mMode = mode;
        return this;
    }

    @NonNull
    public final ToastUtils setGravity(int gravity, int xOffset, int yOffset) {
        this.mGravity = gravity;
        this.mXOffset = xOffset;
        this.mYOffset = yOffset;
        return this;
    }

    @NonNull
    public final ToastUtils setBgColor(@ColorInt int backgroundColor) {
        this.mBgColor = backgroundColor;
        return this;
    }

    @NonNull
    public final ToastUtils setBgResource(@DrawableRes int bgResource) {
        this.mBgResource = bgResource;
        return this;
    }

    @NonNull
    public final ToastUtils setTextColor(@ColorInt int msgColor) {
        this.mTextColor = msgColor;
        return this;
    }

    @NonNull
    public final ToastUtils setTextSize(int textSize) {
        this.mTextSize = textSize;
        return this;
    }

    @NonNull
    public final ToastUtils setDurationIsLong(boolean isLong) {
        this.isLong = isLong;
        return this;
    }

    @NonNull
    public final ToastUtils setLeftIcon(@DrawableRes int resId) {
        return this.setLeftIcon(ContextCompat.getDrawable((Context)Utils.getApp(), (int)resId));
    }

    @NonNull
    public final ToastUtils setLeftIcon(@Nullable Drawable drawable2) {
        this.mIcons[0] = drawable2;
        return this;
    }

    @NonNull
    public final ToastUtils setTopIcon(@DrawableRes int resId) {
        return this.setTopIcon(ContextCompat.getDrawable((Context)Utils.getApp(), (int)resId));
    }

    @NonNull
    public final ToastUtils setTopIcon(@Nullable Drawable drawable2) {
        this.mIcons[1] = drawable2;
        return this;
    }

    @NonNull
    public final ToastUtils setRightIcon(@DrawableRes int resId) {
        return this.setRightIcon(ContextCompat.getDrawable((Context)Utils.getApp(), (int)resId));
    }

    @NonNull
    public final ToastUtils setRightIcon(@Nullable Drawable drawable2) {
        this.mIcons[2] = drawable2;
        return this;
    }

    @NonNull
    public final ToastUtils setBottomIcon(int resId) {
        return this.setBottomIcon(ContextCompat.getDrawable((Context)Utils.getApp(), (int)resId));
    }

    @NonNull
    public final ToastUtils setBottomIcon(@Nullable Drawable drawable2) {
        this.mIcons[3] = drawable2;
        return this;
    }

    @NonNull
    public final ToastUtils setNotUseSystemToast() {
        this.isNotUseSystemToast = true;
        return this;
    }

    @NonNull
    public static ToastUtils getDefaultMaker() {
        return DEFAULT_MAKER;
    }

    public final void show(@Nullable CharSequence text) {
        ToastUtils.show(text, this.getDuration(), this);
    }

    public final void show(@StringRes int resId) {
        ToastUtils.show(UtilsBridge.getString(resId), this.getDuration(), this);
    }

    public final void show(@StringRes int resId, Object ... args) {
        ToastUtils.show(UtilsBridge.getString(resId, args), this.getDuration(), this);
    }

    public final void show(@Nullable String format, Object ... args) {
        ToastUtils.show(UtilsBridge.format(format, args), this.getDuration(), this);
    }

    public final void show(@NonNull View view) {
        ToastUtils.show(view, this.getDuration(), this);
    }

    private int getDuration() {
        return this.isLong ? 1 : 0;
    }

    private View tryApplyUtilsToastView(CharSequence text) {
        if (!"dark".equals(this.mMode) && !"light".equals(this.mMode) && this.mIcons[0] == null && this.mIcons[1] == null && this.mIcons[2] == null && this.mIcons[3] == null) {
            return null;
        }
        View toastView = UtilsBridge.layoutId2View(R.layout.utils_toast_view);
        TextView messageTv = (TextView)toastView.findViewById(16908299);
        if ("dark".equals(this.mMode)) {
            GradientDrawable bg = (GradientDrawable)toastView.getBackground().mutate();
            bg.setColor(Color.parseColor((String)"#BB000000"));
            messageTv.setTextColor(-1);
        }
        messageTv.setText(text);
        if (this.mIcons[0] != null) {
            View leftIconView = toastView.findViewById(R.id.utvLeftIconView);
            ViewCompat.setBackground((View)leftIconView, (Drawable)this.mIcons[0]);
            leftIconView.setVisibility(0);
        }
        if (this.mIcons[1] != null) {
            View topIconView = toastView.findViewById(R.id.utvTopIconView);
            ViewCompat.setBackground((View)topIconView, (Drawable)this.mIcons[1]);
            topIconView.setVisibility(0);
        }
        if (this.mIcons[2] != null) {
            View rightIconView = toastView.findViewById(R.id.utvRightIconView);
            ViewCompat.setBackground((View)rightIconView, (Drawable)this.mIcons[2]);
            rightIconView.setVisibility(0);
        }
        if (this.mIcons[3] != null) {
            View bottomIconView = toastView.findViewById(R.id.utvBottomIconView);
            ViewCompat.setBackground((View)bottomIconView, (Drawable)this.mIcons[3]);
            bottomIconView.setVisibility(0);
        }
        return toastView;
    }

    public static void showShort(@Nullable CharSequence text) {
        ToastUtils.show(text, 0, DEFAULT_MAKER);
    }

    public static void showShort(@StringRes int resId) {
        ToastUtils.show(UtilsBridge.getString(resId), 0, DEFAULT_MAKER);
    }

    public static void showShort(@StringRes int resId, Object ... args) {
        ToastUtils.show(UtilsBridge.getString(resId, args), 0, DEFAULT_MAKER);
    }

    public static void showShort(@Nullable String format, Object ... args) {
        ToastUtils.show(UtilsBridge.format(format, args), 0, DEFAULT_MAKER);
    }

    public static void showLong(@Nullable CharSequence text) {
        try {
            ToastUtils.show(text, 1, DEFAULT_MAKER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showLong(@StringRes int resId) {
        ToastUtils.show(UtilsBridge.getString(resId), 1, DEFAULT_MAKER);
    }

    public static void showLong(@StringRes int resId, Object ... args) {
        ToastUtils.show(UtilsBridge.getString(resId, args), 1, DEFAULT_MAKER);
    }

    public static void showLong(@Nullable String format, Object ... args) {
        ToastUtils.show(UtilsBridge.format(format, args), 1, DEFAULT_MAKER);
    }

    public static void cancel() {
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sWeakToast != null) {
                    IToast iToast = (IToast)sWeakToast.get();
                    if (iToast != null) {
                        iToast.cancel();
                    }
                    sWeakToast = null;
                }
            }
        });
    }

    private static void show(@Nullable CharSequence text, int duration, ToastUtils utils) {
        ToastUtils.show(null, ToastUtils.getToastFriendlyText(text), duration, utils);
    }

    private static void show(@NonNull View view, int duration, ToastUtils utils) {
        ToastUtils.show(view, null, duration, utils);
    }

    private static void show(final @Nullable View view, final @Nullable CharSequence text, final int duration, final @NonNull ToastUtils utils) {
        UtilsBridge.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtils.cancel();
                IToast iToast = ToastUtils.newToast(utils);
                sWeakToast = new WeakReference<IToast>(iToast);
                if (view != null) {
                    iToast.setToastView(view);
                } else {
                    iToast.setToastView(text);
                }
                iToast.show(duration);
            }
        });
    }

    private static CharSequence getToastFriendlyText(CharSequence src) {
        CharSequence text = src;
        if (text == null) {
            text = NULL;
        } else if (text.length() == 0) {
            text = NOTHING;
        }
        return text;
    }

    private static IToast newToast(ToastUtils toastUtils) {
        if (!toastUtils.isNotUseSystemToast && NotificationManagerCompat.from((Context)Utils.getApp()).areNotificationsEnabled()) {
            if (Build.VERSION.SDK_INT < 23) {
                return new SystemToast(toastUtils);
            }
            if (!UtilsBridge.isGrantedDrawOverlays()) {
                return new SystemToast(toastUtils);
            }
        }
        if (Build.VERSION.SDK_INT < 25) {
            return new WindowManagerToast(toastUtils, 2005);
        }
        if (UtilsBridge.isGrantedDrawOverlays()) {
            if (Build.VERSION.SDK_INT >= 26) {
                return new WindowManagerToast(toastUtils, 2038);
            }
            return new WindowManagerToast(toastUtils, 2002);
        }
        return new ActivityToast(toastUtils);
    }

    public static final class UtilsMaxWidthRelativeLayout
    extends RelativeLayout {
        private static final int SPACING = UtilsBridge.dp2px(80.0f);

        public UtilsMaxWidthRelativeLayout(Context context) {
            super(context);
        }

        public UtilsMaxWidthRelativeLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public UtilsMaxWidthRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int widthMaxSpec = View.MeasureSpec.makeMeasureSpec((int)(UtilsBridge.getAppScreenWidth() - SPACING), (int)Integer.MIN_VALUE);
            super.onMeasure(widthMaxSpec, heightMeasureSpec);
        }
    }

    static interface IToast {
        public void setToastView(View var1);

        public void setToastView(CharSequence var1);

        public void show(int var1);

        public void cancel();
    }

    static abstract class AbsToast
    implements IToast {
        protected Toast mToast = new Toast((Context)Utils.getApp());
        protected ToastUtils mToastUtils;
        protected View mToastView;

        AbsToast(ToastUtils toastUtils) {
            this.mToastUtils = toastUtils;
            if (this.mToastUtils.mGravity != -1 || this.mToastUtils.mXOffset != -1 || this.mToastUtils.mYOffset != -1) {
                this.mToast.setGravity(this.mToastUtils.mGravity, this.mToastUtils.mXOffset, this.mToastUtils.mYOffset);
            }
        }

        @Override
        public void setToastView(View view) {
            this.mToastView = view;
            this.mToast.setView(this.mToastView);
        }

        @Override
        public void setToastView(CharSequence text) {
            View utilsToastView = this.mToastUtils.tryApplyUtilsToastView(text);
            if (utilsToastView != null) {
                this.setToastView(utilsToastView);
                this.processRtlIfNeed();
                return;
            }
            this.mToastView = this.mToast.getView();
            if (this.mToastView == null || this.mToastView.findViewById(16908299) == null) {
                this.setToastView(UtilsBridge.layoutId2View(R.layout.utils_toast_view));
            }
            TextView messageTv = (TextView)this.mToastView.findViewById(16908299);
            messageTv.setText(text);
            if (this.mToastUtils.mTextColor != -16777217) {
                messageTv.setTextColor(this.mToastUtils.mTextColor);
            }
            if (this.mToastUtils.mTextSize != -1) {
                messageTv.setTextSize((float)this.mToastUtils.mTextSize);
            }
            this.setBg(messageTv);
            this.processRtlIfNeed();
        }

        private void processRtlIfNeed() {
            if (UtilsBridge.isLayoutRtl()) {
                this.setToastView(this.getToastViewSnapshot(-1));
            }
        }

        private void setBg(TextView msgTv) {
            if (this.mToastUtils.mBgResource != -1) {
                this.mToastView.setBackgroundResource(this.mToastUtils.mBgResource);
                msgTv.setBackgroundColor(0);
            } else if (this.mToastUtils.mBgColor != -16777217) {
                Drawable toastBg = this.mToastView.getBackground();
                Drawable msgBg = msgTv.getBackground();
                if (toastBg != null && msgBg != null) {
                    toastBg.mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mToastUtils.mBgColor, PorterDuff.Mode.SRC_IN));
                    msgTv.setBackgroundColor(0);
                } else if (toastBg != null) {
                    toastBg.mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mToastUtils.mBgColor, PorterDuff.Mode.SRC_IN));
                } else if (msgBg != null) {
                    msgBg.mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mToastUtils.mBgColor, PorterDuff.Mode.SRC_IN));
                } else {
                    this.mToastView.setBackgroundColor(this.mToastUtils.mBgColor);
                }
            }
        }

        @Override
        @CallSuper
        public void cancel() {
            if (this.mToast != null) {
                this.mToast.cancel();
            }
            this.mToast = null;
            this.mToastView = null;
        }

        View getToastViewSnapshot(int index) {
            Bitmap bitmap = UtilsBridge.view2Bitmap(this.mToastView);
            ImageView toastIv = new ImageView((Context)Utils.getApp());
            toastIv.setTag((Object)(ToastUtils.TAG_TOAST + index));
            toastIv.setImageBitmap(bitmap);
            return toastIv;
        }
    }

    static final class ActivityToast
    extends AbsToast {
        private static int sShowingIndex = 0;
        private Utils.ActivityLifecycleCallbacks mActivityLifecycleCallbacks;
        private IToast iToast;

        ActivityToast(ToastUtils toastUtils) {
            super(toastUtils);
        }

        @Override
        public void show(int duration) {
            if (this.mToast == null) {
                return;
            }
            if (!UtilsBridge.isAppForeground()) {
                this.iToast = this.showSystemToast(duration);
                return;
            }
            boolean hasAliveActivity = false;
            for (Activity activity : UtilsBridge.getActivityList()) {
                if (!UtilsBridge.isActivityAlive(activity)) continue;
                if (!hasAliveActivity) {
                    hasAliveActivity = true;
                    this.iToast = this.showWithActivityWindow(activity, duration);
                    continue;
                }
                this.showWithActivityView(activity, sShowingIndex, true);
            }
            if (hasAliveActivity) {
                this.registerLifecycleCallback();
                UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    public void run() {
                        this.cancel();
                    }
                }, duration == 0 ? 2000L : 3500L);
                ++sShowingIndex;
            } else {
                this.iToast = this.showSystemToast(duration);
            }
        }

        @Override
        public void cancel() {
            if (this.isShowing()) {
                this.unregisterLifecycleCallback();
                for (Activity activity : UtilsBridge.getActivityList()) {
                    ViewGroup decorView;
                    View toastView;
                    Window window;
                    if (!UtilsBridge.isActivityAlive(activity) || (window = activity.getWindow()) == null || (toastView = (decorView = (ViewGroup)window.getDecorView()).findViewWithTag((Object)(ToastUtils.TAG_TOAST + (sShowingIndex - 1)))) == null) continue;
                    try {
                        decorView.removeView(toastView);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.iToast != null) {
                this.iToast.cancel();
                this.iToast = null;
            }
            super.cancel();
        }

        private IToast showSystemToast(int duration) {
            SystemToast systemToast = new SystemToast(this.mToastUtils);
            systemToast.mToast = this.mToast;
            systemToast.show(duration);
            return systemToast;
        }

        private IToast showWithActivityWindow(Activity activity, int duration) {
            WindowManagerToast wmToast = new WindowManagerToast(this.mToastUtils, activity.getWindowManager(), 99);
            wmToast.mToastView = this.getToastViewSnapshot(-1);
            wmToast.mToast = this.mToast;
            wmToast.show(duration);
            return wmToast;
        }

        private void showWithActivityView(Activity activity, int index, boolean useAnim) {
            Window window = activity.getWindow();
            if (window != null) {
                ViewGroup decorView = (ViewGroup)window.getDecorView();
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                lp.gravity = this.mToast.getGravity();
                lp.bottomMargin = this.mToast.getYOffset() + UtilsBridge.getNavBarHeight();
                lp.topMargin = this.mToast.getYOffset() + UtilsBridge.getStatusBarHeight();
                lp.leftMargin = this.mToast.getXOffset();
                View toastViewSnapshot = this.getToastViewSnapshot(index);
                if (useAnim) {
                    toastViewSnapshot.setAlpha(0.0f);
                    toastViewSnapshot.animate().alpha(1.0f).setDuration(200L).start();
                }
                decorView.addView(toastViewSnapshot, (ViewGroup.LayoutParams)lp);
            }
        }

        private void registerLifecycleCallback() {
            final int index = sShowingIndex;
            this.mActivityLifecycleCallbacks = new Utils.ActivityLifecycleCallbacks(){

                @Override
                public void onActivityCreated(@NonNull Activity activity) {
                    if (this.isShowing()) {
                        this.showWithActivityView(activity, index, false);
                    }
                }
            };
            UtilsBridge.addActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
        }

        private void unregisterLifecycleCallback() {
            UtilsBridge.removeActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
            this.mActivityLifecycleCallbacks = null;
        }

        private boolean isShowing() {
            return this.mActivityLifecycleCallbacks != null;
        }
    }

    static final class WindowManagerToast
    extends AbsToast {
        private WindowManager mWM;
        private WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();

        WindowManagerToast(ToastUtils toastUtils, int type) {
            super(toastUtils);
            this.mWM = (WindowManager)Utils.getApp().getSystemService("window");
            this.mParams.type = type;
        }

        WindowManagerToast(ToastUtils toastUtils, WindowManager wm, int type) {
            super(toastUtils);
            this.mWM = wm;
            this.mParams.type = type;
        }

        @Override
        public void show(int duration) {
            if (this.mToast == null) {
                return;
            }
            this.mParams.height = -2;
            this.mParams.width = -2;
            this.mParams.format = -3;
            this.mParams.windowAnimations = 16973828;
            this.mParams.setTitle((CharSequence)"ToastWithoutNotification");
            this.mParams.flags = 152;
            this.mParams.packageName = Utils.getApp().getPackageName();
            this.mParams.gravity = this.mToast.getGravity();
            if ((this.mParams.gravity & 7) == 7) {
                this.mParams.horizontalWeight = 1.0f;
            }
            if ((this.mParams.gravity & 0x70) == 112) {
                this.mParams.verticalWeight = 1.0f;
            }
            this.mParams.x = this.mToast.getXOffset();
            this.mParams.y = this.mToast.getYOffset();
            this.mParams.horizontalMargin = this.mToast.getHorizontalMargin();
            this.mParams.verticalMargin = this.mToast.getVerticalMargin();
            try {
                if (this.mWM != null) {
                    this.mWM.addView(this.mToastView, (ViewGroup.LayoutParams)this.mParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    this.cancel();
                }
            }, duration == 0 ? 2000L : 3500L);
        }

        @Override
        public void cancel() {
            try {
                if (this.mWM != null) {
                    this.mWM.removeViewImmediate(this.mToastView);
                    this.mWM = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.cancel();
        }
    }

    static final class SystemToast
    extends AbsToast {
        SystemToast(ToastUtils toastUtils) {
            super(toastUtils);
            if (Build.VERSION.SDK_INT == 25) {
                try {
                    Field mTNField = Toast.class.getDeclaredField("mTN");
                    mTNField.setAccessible(true);
                    Object mTN = mTNField.get(this.mToast);
                    Field mTNmHandlerField = mTNField.getType().getDeclaredField("mHandler");
                    mTNmHandlerField.setAccessible(true);
                    Handler tnHandler = (Handler)mTNmHandlerField.get(mTN);
                    mTNmHandlerField.set(mTN, (Object)new SafeHandler(tnHandler));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void show(int duration) {
            if (this.mToast == null) {
                return;
            }
            this.mToast.setDuration(duration);
            this.mToast.show();
        }

        static class SafeHandler
        extends Handler {
            private Handler impl;

            SafeHandler(Handler impl) {
                this.impl = impl;
            }

            public void handleMessage(@NonNull Message msg) {
                this.impl.handleMessage(msg);
            }

            public void dispatchMessage(@NonNull Message msg) {
                try {
                    this.impl.dispatchMessage(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MODE {
        public static final String LIGHT = "light";
        public static final String DARK = "dark";
    }
}

