package com.feasy.feasyprint.adapter;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pDevice;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.feasy.feasyprint.R;
import com.feasy.feasyprint.base.ItemClick;

import java.util.ArrayList;


public class P2pAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context context;
    private ArrayList<WifiP2pDevice> wifiP2pDevices = new ArrayList<>();
    private ItemClick itemClick;

    public P2pAdapter(Context context, ItemClick itemClick) {
        this.context = context;
        this.itemClick = itemClick;
    }


    public void AddP2pDev(WifiP2pDevice wifiP2pDevice) {
        try {
            wifiP2pDevices.add(wifiP2pDevice);
            notifyItemInserted(wifiP2pDevices.size() - 1);
        } catch (Exception e) {

        }
    }

    public ArrayList<WifiP2pDevice> getWifiP2pDevices() {
        return wifiP2pDevices;
    }

    public void ClearData() {
        wifiP2pDevices.clear();
        notifyDataSetChanged();

    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.p2p_item, parent, false);
        return new P2pHold(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof P2pHold) {

            WifiP2pDevice wifiP2pDevice = wifiP2pDevices.get(holder.getLayoutPosition());
            ((P2pHold) holder).txt_dev_name.setText(wifiP2pDevice.deviceName);
            ((P2pHold) holder).rela_bg.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemClick.onClick(holder.getLayoutPosition());
                }
            });

        }
    }

    @Override
    public int getItemCount() {
        if (null == wifiP2pDevices) {
            return 0;
        }
        return wifiP2pDevices.size();
    }


    private class P2pHold extends RecyclerView.ViewHolder {

        private TextView txt_dev_name;
        private RelativeLayout rela_bg;

        public P2pHold(@NonNull View itemView) {
            super(itemView);
            txt_dev_name = itemView.findViewById(R.id.txt_dev_name);
            rela_bg = itemView.findViewById(R.id.rela_bg);
        }


    }


}
