package com.feasy.feasyprint.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.feasy.feasyprint.R;
import com.feasy.feasyprint.base.ItemClick;
import com.feasy.feasyprint.model.SendBean;

import java.util.ArrayList;


public class SendListAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context context;
    private ItemClick itemClick;
    private ArrayList<SendBean> sendBeans;

    public SendListAdapter(Context context, ItemClick itemClick) {

        this.context = context;
        this.itemClick = itemClick;


    }

    public void setSendBeans(ArrayList<SendBean> sendBeans) {
        this.sendBeans = sendBeans;
        notifyDataSetChanged();
    }

    public ArrayList<SendBean> getSendBeans() {
        return sendBeans;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.send_item, parent, false);
        return new SendViewHold(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof SendViewHold) {

            SendBean sendBean = sendBeans.get(holder.getLayoutPosition());
            if (sendBean.isSelect()) {
                ((SendViewHold) holder).rela_bg.setBackgroundResource(R.drawable.shap_blue_sk8dp);
                ((SendViewHold) holder).img_left.setBackgroundResource(R.mipmap.primary_icon_selected);
            } else {
                ((SendViewHold) holder).rela_bg.setBackgroundResource(R.drawable.shap_white_ss8dp);
                ((SendViewHold) holder).img_left.setBackgroundResource(R.mipmap.primary_icon_unselected);
            }
            ((SendViewHold) holder).txt_tips.setText(sendBean.getTips());
            ((SendViewHold) holder).txt_name.setText(sendBean.getName());

            ((SendViewHold) holder).rela_bg.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemClick.onClick(holder.getLayoutPosition());
                }
            });

        }

    }

    @Override
    public int getItemCount() {
        if (null == sendBeans) {
            return 0;
        }
        return sendBeans.size();
    }


    private class SendViewHold extends RecyclerView.ViewHolder {


        private RelativeLayout rela_bg;
        private ImageView img_left;

        private TextView txt_tips, txt_name;

        public SendViewHold(@NonNull View itemView) {
            super(itemView);

            rela_bg = itemView.findViewById(R.id.rela_bg);
            img_left = itemView.findViewById(R.id.img_left);
            txt_tips = itemView.findViewById(R.id.txt_tips);
            txt_name = itemView.findViewById(R.id.txt_name);


        }
    }


}
