/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.logger;

import a.a.c.b;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.feasycom.logger.FormatStrategy;
import com.feasycom.logger.LogStrategy;
import com.feasycom.logger.LogcatLogStrategy;
import com.feasycom.logger.Logger;

public class PrettyFormatStrategy
implements FormatStrategy {
    private static final int CHUNK_SIZE = 4000;
    private static final int MIN_STACK_OFFSET = 5;
    private static final char TOP_LEFT_CORNER = '\u250c';
    private static final char BOTTOM_LEFT_CORNER = '\u2514';
    private static final char MIDDLE_CORNER = '\u251c';
    private static final char HORIZONTAL_LINE = '\u2502';
    private static final String DOUBLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String SINGLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private final int methodCount;
    private final int methodOffset;
    private final boolean showThreadInfo;
    @NonNull
    private final LogStrategy logStrategy;
    @Nullable
    private final String tag;

    private PrettyFormatStrategy(@NonNull Builder builder) {
        Builder builder2 = builder;
        b.a(builder2);
        this.methodCount = builder2.methodCount;
        this.methodOffset = builder.methodOffset;
        this.showThreadInfo = builder.showThreadInfo;
        this.logStrategy = builder.logStrategy;
        this.tag = builder.tag;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(null);
    }

    private void logTopBorder(int n, @Nullable String string) {
        this.logChunk(n, string, TOP_BORDER);
    }

    private void logHeaderContent(int n, @Nullable String string, int n2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (this.showThreadInfo) {
            this.logChunk(n, string, "\u2502 Thread: " + Thread.currentThread().getName());
            this.logDivider(n, string);
        }
        String string2 = "";
        int n3 = this.getStackOffset(stackTraceElementArray) + this.methodOffset;
        if (n2 + n3 > stackTraceElementArray.length) {
            n2 = stackTraceElementArray.length - n3 - 1;
        }
        while (n2 > 0) {
            int n4 = n2 + n3;
            if (n4 < stackTraceElementArray.length) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('\u2502').append(' ').append(string2).append(this.getSimpleClassName(stackTraceElementArray[n4].getClassName())).append(".").append(stackTraceElementArray[n4].getMethodName()).append(" ").append(" (").append(stackTraceElementArray[n4].getFileName()).append(":").append(stackTraceElementArray[n4].getLineNumber()).append(")");
                string2 = string2 + "   ";
                this.logChunk(n, string, stringBuilder.toString());
            }
            --n2;
        }
    }

    private void logBottomBorder(int n, @Nullable String string) {
        this.logChunk(n, string, BOTTOM_BORDER);
    }

    private void logDivider(int n, @Nullable String string) {
        this.logChunk(n, string, MIDDLE_BORDER);
    }

    private void logContent(int n, @Nullable String string, @NonNull String stringArray) {
        b.a(stringArray);
        stringArray = stringArray.split(System.getProperty("line.separator"));
        int n2 = stringArray.length;
        for (int k = 0; k < n2; ++k) {
            this.logChunk(n, string, "\u2502 " + stringArray[k]);
        }
    }

    private void logChunk(int n, @Nullable String string, @NonNull String string2) {
        b.a(string2);
        this.logStrategy.log(n, string, string2);
    }

    private String getSimpleClassName(@NonNull String string) {
        String string2 = string;
        b.a(string2);
        return string2.substring(string2.lastIndexOf(".") + 1);
    }

    private int getStackOffset(@NonNull StackTraceElement[] stackTraceElementArray) {
        b.a(stackTraceElementArray);
        for (int k = 5; k < stackTraceElementArray.length; ++k) {
            String string = stackTraceElementArray[k].getClassName();
            if (string.equals(a.a.c.a.class.getName()) || string.equals(Logger.class.getName())) continue;
            return k + -1;
        }
        return -1;
    }

    @Nullable
    private String formatTag(@Nullable String string) {
        if (!b.a(string) && !b.a(this.tag, string)) {
            return this.tag + "-" + string;
        }
        return this.tag;
    }

    public /* synthetic */ PrettyFormatStrategy(Builder builder, a a2) {
        this(builder);
    }

    @Override
    public void log(int n, @Nullable String string, @NonNull String string2) {
        PrettyFormatStrategy prettyFormatStrategy = this;
        b.a(string2);
        string = prettyFormatStrategy.formatTag(string);
        prettyFormatStrategy.logTopBorder(n, string);
        int n2 = prettyFormatStrategy.methodCount;
        prettyFormatStrategy.logHeaderContent(n, string, n2);
        byte[] byArray = string2.getBytes();
        int n3 = byArray.length;
        if (n3 <= 4000) {
            if (this.methodCount > 0) {
                this.logDivider(n, string);
            }
            PrettyFormatStrategy prettyFormatStrategy2 = this;
            prettyFormatStrategy2.logContent(n, string, string2);
            prettyFormatStrategy2.logBottomBorder(n, string);
            return;
        }
        if (this.methodCount > 0) {
            this.logDivider(n, string);
        }
        for (int k = 0; k < n3; k += 4000) {
            String string3;
            int n4 = Math.min(n3 - k, 4000);
            String string4 = string3;
            string3 = new String(byArray, k, n4);
            this.logContent(n, string, string4);
        }
        this.logBottomBorder(n, string);
    }

    public static class Builder {
        public int methodCount = 2;
        public int methodOffset = 0;
        public boolean showThreadInfo = true;
        @Nullable
        public LogStrategy logStrategy;
        @Nullable
        public String tag = "PRETTY_LOGGER";

        private Builder() {
        }

        public /* synthetic */ Builder(a a2) {
            this();
        }

        @NonNull
        public Builder methodCount(int n) {
            this.methodCount = n;
            return this;
        }

        @NonNull
        public Builder methodOffset(int n) {
            this.methodOffset = n;
            return this;
        }

        @NonNull
        public Builder showThreadInfo(boolean bl) {
            this.showThreadInfo = bl;
            return this;
        }

        @NonNull
        public Builder logStrategy(@Nullable LogStrategy logStrategy) {
            this.logStrategy = logStrategy;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String string) {
            this.tag = string;
            return this;
        }

        @NonNull
        public PrettyFormatStrategy build() {
            if (this.logStrategy == null) {
                LogcatLogStrategy logcatLogStrategy;
                LogcatLogStrategy logcatLogStrategy2 = logcatLogStrategy;
                logcatLogStrategy = new LogcatLogStrategy();
                this.logStrategy = logcatLogStrategy2;
            }
            return new PrettyFormatStrategy(this, null);
        }
    }
}

