/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.ota.utils;

public class BT1038Utils {
    public static int littleEndianRead16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    public static int littleEndianRead24(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16;
    }

    public static long littleEndianRead32(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24;
    }

    public static void littleEndianStore16(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        int n3 = n + 1;
        byArray[n3] = (byte)(n2 >> 8 & 0xFF);
    }

    public static void littleEndianStore32(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l & 0xFFL);
        int n2 = n + 1;
        byArray[n2] = (byte)(l >> 8 & 0xFFL);
        n2 = n + 2;
        byArray[n2] = (byte)(l >> 16 & 0xFFL);
        n2 = n + 3;
        byArray[n2] = (byte)(l >> 24 & 0xFFL);
    }

    public static int bigEndianRead16(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int bigEndianRead24(byte[] byArray, int n) {
        return byArray[n + 2] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n] & 0xFF) << 16;
    }

    public static long bigEndianRead32(byte[] byArray, int n) {
        return (long)byArray[n + 3] & 0xFFL | ((long)byArray[n + 2] & 0xFFL) << 8 | ((long)byArray[n + 1] & 0xFFL) << 16 | ((long)byArray[n] & 0xFFL) << 24;
    }

    public static void bigEndianStore16(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        int n3 = n + 1;
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    public static void bigEndianStore24(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 16 & 0xFF);
        int n3 = n + 1;
        byArray[n3] = (byte)(n2 >> 8 & 0xFF);
        n3 = n + 2;
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    public static void bigEndianStore32(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l >> 24 & 0xFFL);
        int n2 = n + 1;
        byArray[n2] = (byte)(l >> 16 & 0xFFL);
        n2 = n + 2;
        byArray[n2] = (byte)(l >> 8 & 0xFFL);
        n2 = n + 3;
        byArray[n2] = (byte)(l & 0xFFL);
    }

    public static void bigEndianStore32To16(short[] sArray, int n, long l) {
        sArray[n] = (short)(l >> 16 & 0xFFFFL);
        int n2 = n + 1;
        sArray[n2] = (short)(l & 0xFFFFL);
    }

    public static void reverseBytes(byte[] byArray, byte[] byArray2, int n) {
        for (int k = 0; k < n; ++k) {
            int n2 = n - 1 - k;
            byArray2[n2] = byArray[k];
        }
    }

    public static void reverse24(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 3);
    }

    public static void reverse32(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 4);
    }

    public static void reverse48(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 6);
    }

    public static void reverse56(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 7);
    }

    public static void reverse64(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 8);
    }

    public static void reverse128(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 16);
    }

    public static void reverse256(byte[] byArray, byte[] byArray2) {
        BT1038Utils.reverseBytes(byArray, byArray2, 32);
    }

    public static char hexToChar(byte by) {
        return (char)(by >= 0 && by <= 9 ? by + 48 : (by >= 10 && by <= 15 ? by + 65 - 10 : 65535));
    }

    public static int charToHex(byte by) {
        return by >= 48 && by <= 57 ? by - 48 : (by >= 97 && by <= 102 ? by - 97 + 10 : (by >= 65 && by <= 70 ? by - 65 + 10 : 65535));
    }

    private static int nibbleForChar(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    public static boolean isDigitalString(byte[] byArray, int n) {
        for (int k = 0; k < n; ++k) {
            if (BT1038Utils.isBetween('0', (char)byArray[k], '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexString(byte[] byArray, int n) {
        for (int k = 0; k < n; ++k) {
            if (BT1038Utils.isBetween('0', (char)byArray[k], '9') || BT1038Utils.isBetween('a', (char)byArray[k], 'f') || BT1038Utils.isBetween('A', (char)byArray[k], 'F')) continue;
            return false;
        }
        return true;
    }

    public static boolean strToHex(byte[] byArray, String string, int n) {
        if (n % 2 != 0) {
            return false;
        }
        for (int k = 0; k < n; k += 2) {
            int n2 = BT1038Utils.nibbleForChar(string.charAt(k));
            byte by = (byte)BT1038Utils.nibbleForChar(string.charAt(k + 1));
            if (n2 != -1 && by != -1) {
                int n3 = n2;
                n2 = k / 2;
                byArray[n2] = (byte)(n3 << 4 | by);
                continue;
            }
            return false;
        }
        return true;
    }

    public static long strToDec(String string, int n) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = l * 10L + (long)(string.charAt(k) - 48);
        }
        return l;
    }

    public static int crc16CCITFalse(byte[] byArray, int n) {
        int n2 = 65535;
        int n3 = 4129;
        block0: while (true) {
            int n4 = n;
            n = n4 + -1;
            if (n4 <= 0) break;
            n2 ^= byArray[byArray.length - n - 1] << 8;
            int n5 = 0;
            while (true) {
                if (n5 >= 8) continue block0;
                n2 = (n2 & 0x8000) != 0 ? n2 << 1 ^ n3 : (n2 <<= 1);
                ++n5;
            }
            break;
        }
        return n2;
    }

    private static boolean isBetween(char c2, char c3, char c4) {
        return c3 >= c2 && c3 <= c4;
    }

    public static byte[] byteMerge(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        n = byArray.length;
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        return byArray3;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[2];
        for (int k = 0; k < 4; ++k) {
            byArray[k] = (byte)(n >> k * 8);
        }
        return byArray;
    }

    public static byte[] convertIntTo24Bits(int n) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n >> 16 & 0xFF);
        byArray2[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
        return byArray;
    }
}

