/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.ota.utils;

import android.content.ContentUris;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.feasycom.ota.bean.DfuFileInfo;
import com.feasycom.ota.utils.TeaCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLDecoder;

@Keep
public class FileUtil {
    public static final String[] moduleNameInfo = new String[]{"BT401", "BT405", "BT426N", "BT501", "BT502", "BT522", "BT616", "BT625", "BT626", "BT803", "BT813D", "BT816S", "BT821", "BT822", "BT826", "BT826N", "BT836", "BT836N", "BT906", "BT909", "BP102", "BT816S3", "BT926", "BT901", "BP109", "BP103", "BP104", "BP201", "BP106", "BP101", "BP671", "BT826H", "BT826NH", "BT826E", "BT826EH"};
    public static final String[] moules = new String[]{"BT401", "BT405", "BT426N", "BT501", "BT502", "BT522", "BT616", "BT625", "BT626", "BT803", "BT813D", "BT816S", "BT821", "BT822", "BT826", "BT826N", "BT836", "BT836N", "BT906", "BT909", "BP102", "BT816S3", "BT926", "BT901", "BP109", "BP103", "BP104", "BP201", "BP106", "BP101", "BP671", "BT826H", "BT826NH", "BT826E", "BT826EH", "BT836B", "BT826B", "BT736", "BT926B", "BT966", "BT721B", "BT886", "BT104B", "BP110", "BP102B", "BP104D", "BT826A", "BT826BA", "BT986"};
    public static final String[] reconnectModule = new String[]{"BT901", "BT906", "BT909", "BT826", "BT926", "BT966"};
    public static char[] charTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] ALPHANUMERIC = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final String Hex = "0123456789ABCDEF";

    public static String getMoules(int n) {
        return moules[n - 1];
    }

    public static String getFileAbsolutePath(Context stringArray, Uri stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)stringArray, (Uri)stringArray2)) {
                if (FileUtil.isExternalStorageDocument((Uri)stringArray2)) {
                    stringArray = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                    if ("primary".equalsIgnoreCase(stringArray[0])) {
                        return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    }
                } else {
                    if (FileUtil.isDownloadsDocument((Uri)stringArray2)) {
                        return FileUtil.getDataColumn((Context)stringArray, ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray2))), null, null);
                    }
                    if (FileUtil.isMediaDocument((Uri)stringArray2)) {
                        stringArray2 = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                        String string = stringArray2[0];
                        Uri uri = null;
                        if ("image".equals(string)) {
                            uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(string)) {
                            uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(string)) {
                            uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String[] stringArray3 = stringArray;
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = stringArray2[1];
                        return FileUtil.getDataColumn((Context)stringArray3, uri, "_id=?", stringArray);
                    }
                }
            } else {
                if ("content".equalsIgnoreCase(stringArray2.getScheme())) {
                    if (FileUtil.isGooglePhotosUri((Uri)stringArray2)) {
                        return stringArray2.getLastPathSegment();
                    }
                    return FileUtil.getDataColumn((Context)stringArray, (Uri)stringArray2, null, null);
                }
                if ("file".equalsIgnoreCase(stringArray2.getScheme())) {
                    return stringArray2.getPath();
                }
            }
            return null;
        }
        return null;
    }

    public static String getModelName(String string) {
        if (string != null && !"".equals(string) && string.split("_").length == 8) {
            return string.split("_")[0];
        }
        return null;
    }

    public static String getAppVersion(String string) {
        if (string != null && !"".equals(string) && string.split("_").length == 8) {
            return string.split("_")[6];
        }
        return null;
    }

    public static String getBootLoaderVersion(String string) {
        if (string != null && !"".equals(string) && string.split("_").length == 8) {
            return string.split("_")[4];
        }
        return null;
    }

    public static byte[] readFile(String object) {
        if (object != null && ((String)object).length() >= 1) {
            int n;
            FileInputStream fileInputStream;
            File file;
            object = URLDecoder.decode((String)object, "UTF-8").replace("file:", "");
            File file2 = file;
            file = new File((String)object, "");
            object = fileInputStream;
            fileInputStream = new FileInputStream(file2);
            try {
                n = (int)file.length();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            byte[] byArray = new byte[n];
            ((FileInputStream)object).read(byArray);
            return byArray;
        }
        return null;
    }

    public static String getDataColumn(Context context, Uri uri, String string, String[] stringArray) {
        block6: {
            Context context2 = context;
            context = null;
            String[] stringArray2 = new String[1];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = "_data";
            try {
                context = context2.getContentResolver().query(uri, stringArray3, string, stringArray, null);
                if (context == null) break block6;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    context.close();
                }
                throw throwable;
            }
            if (!context.moveToFirst()) break block6;
            Context context3 = context;
            String string2 = context3.getString(context3.getColumnIndexOrThrow("_data"));
            context.close();
            return string2;
        }
        if (context != null) {
            context.close();
        }
        return "";
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static String bytesToHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "";
        }
        return FileUtil.bytesToHex(byArray, 0, byArray.length, false);
    }

    public static String bytesToHex(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray != null && byArray.length > n && n2 > 0) {
            n2 = Math.min(n2, byArray.length - n);
            char[] cArray = new char[n2 * 2];
            for (int k = 0; k < n2; ++k) {
                int n3 = byArray[n + k] & 0xFF;
                int n4 = k * 2;
                char[] cArray2 = HEX_ARRAY;
                int n5 = n3;
                cArray[n4] = cArray2[n3 >>> 4];
                n3 = n4 + 1;
                cArray[n3] = HEX_ARRAY[n5 & 0xF];
            }
            if (!bl) {
                return new String(cArray);
            }
            return "0x" + new String(cArray);
        }
        return "";
    }

    public static byte[] hexToByte(String string) {
        if (string.length() <= 0) {
            return new byte[0];
        }
        if ((string = string.replace(" ", "")).length() % 2 == 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(string.length() - 1, '0');
            string = stringBuffer.toString();
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            int n2 = n + 2;
            String string2 = string.substring(n, n2);
            if (n == 0) {
                byArray[n] = (byte)Integer.parseInt(string2, 16);
            } else {
                byArray[n /= 2] = (byte)Integer.parseInt(string2, 16);
            }
            n = n2;
        }
        return byArray;
    }

    public static String formattingOneIntToStrings(int n) {
        int n2 = (n &= 0xF) + 1;
        return Hex.substring(n, n2);
    }

    public static int formattingOneHexToInt(String string) {
        if (string != null && string.length() == 1) {
            return Hex.indexOf(string.toUpperCase());
        }
        return 0;
    }

    public static int formattingHexToInt(String string) {
        String string2 = string;
        string = string2.substring(0, 1);
        return FileUtil.formattingOneHexToInt(string) * 16 + FileUtil.formattingOneHexToInt(string2.substring(1, 2));
    }

    public static int add(int n, int n2) {
        int n3 = n;
        n = n3 & n2;
        n2 = n3 ^ n2;
        while (n != 0) {
            int n4 = n2;
            n2 = n4 & (n <<= 1);
            n = n4 ^ n;
            int n5 = n2;
            n2 = n;
            n = n5;
        }
        return n2;
    }

    public static int minus(int n, int n2) {
        return FileUtil.add(n, FileUtil.add(~n2, 1));
    }

    private static long transform(byte by) {
        long l = by;
        if (l < 0L) {
            l += 256L;
        }
        return l;
    }

    public static int byteToInt_2(byte by) {
        return by & 0xFF;
    }

    public static int byteToInt_2(byte by, byte by2) {
        byte by3 = by;
        by = (byte)(by2 & 0xFF);
        return (by3 & 0xFF) + (by << 8);
    }

    public static int byteToInt_2(byte by, byte by2, byte by3, byte by4) {
        byte by5 = by;
        byte by6 = by2;
        by = (byte)(by4 & 0xFF);
        by2 = (byte)(by3 & 0xFF);
        by3 = (byte)(by6 & 0xFF);
        return (by5 & 0xFF) + (by3 << 8) + (by2 << 16) + (by << 24);
    }

    public static int stringToInt(String string) {
        String string2 = string;
        string = string2.substring(0, 2);
        int n = FileUtil.formattingHexToInt(string);
        return FileUtil.byteToInt_2((byte)n, (byte)FileUtil.formattingHexToInt(string2.substring(2, 4)));
    }

    public static int stringToInt1(String string) {
        String string2 = string.replace(" ", "");
        string = string2.substring(0, 2);
        int n = FileUtil.formattingHexToInt(string2.substring(2, 4));
        return FileUtil.byteToInt_2((byte)n, (byte)FileUtil.formattingHexToInt(string));
    }

    public static short byteToShort_2(byte by, byte by2) {
        return (short)FileUtil.add(by & 0xFF, by2 << 8);
    }

    public static int[] byteToInt(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        int n = 0;
        for (int k = 0; k < byArray.length; k += 4) {
            nArray[n] = (int)(FileUtil.transform(byArray[k]) | FileUtil.transform(byArray[k + 1]) << 8 | FileUtil.transform(byArray[k + 2]) << 16 | FileUtil.transform(byArray[k + 3]) << 24);
            ++n;
        }
        return nArray;
    }

    public static byte[] intToByte(int[] nArray) {
        int n = nArray.length * 4;
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int k = 0; k < n; k += 4) {
            byArray[k] = (byte)(nArray[n2] & 0xFF);
            int n3 = k + 1;
            byArray[n3] = (byte)(nArray[n2] >> 8 & 0xFF);
            n3 = k + 2;
            byArray[n3] = (byte)(nArray[n2] >> 16 & 0xFF);
            n3 = k + 3;
            byArray[n3] = (byte)(nArray[n2] >> 24 & 0xFF);
            ++n2;
        }
        return byArray;
    }

    public static long intToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    @NonNull
    public static String getFileName(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        if (n != -1 && n2 != -1) {
            return string.substring(n + 1, n2);
        }
        return "";
    }

    public static long readFileSize(String string) {
        if (string != null && string.length() >= 1) {
            string = URLDecoder.decode(string, "UTF-8").replace("file:", "");
            return new File(string, "").length();
        }
        return 0L;
    }

    public static byte[] readFileToByte(String string) {
        if (string != null && string.length() >= 1) {
            FileInputStream fileInputStream;
            string = URLDecoder.decode(string, "UTF-8").replace("file:", "");
            FileInputStream fileInputStream2 = fileInputStream;
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[(int)new File(string, "").length()];
            fileInputStream2.read(byArray);
            return byArray;
        }
        return null;
    }

    public static InputStream getFileStream(String string) {
        if (string != null && string.length() >= 1) {
            string = URLDecoder.decode(string, "UTF-8").replace("file:", "");
            return new FileInputStream(string);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileByInputString(InputStream closeable) {
        StringBuffer stringBuffer;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        Object object = inputStreamReader;
        inputStreamReader = new InputStreamReader((InputStream)closeable);
        closeable = bufferedReader;
        bufferedReader = new BufferedReader((Reader)object);
        object = stringBuffer;
        stringBuffer = new StringBuffer("");
        while (true) {
            Object object2;
            String string;
            try {
                string = ((BufferedReader)closeable).readLine();
                if (string == null) return new String((StringBuffer)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return new String((StringBuffer)object);
            }
            {
                Object object3 = object;
                object2 = object3;
                ((StringBuffer)object3).append(string);
            }
            {
                ((StringBuffer)object2).append("\n");
            }
        }
    }

    public static boolean isSdCardExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static DfuFileInfo getDfuFileInformation(byte[] byArray) {
        return new TeaCode().getDfuFileInformation(byArray);
    }

    private static boolean isReconnect(String string) {
        String[] stringArray = reconnectModule;
        int n = reconnectModule.length;
        for (int k = 0; k < n; ++k) {
            if (!stringArray[k].equals(string)) continue;
            return false;
        }
        return true;
    }

    public static String getModelName(int n) {
        String[] stringArray = moduleNameInfo;
        if (n > moduleNameInfo.length) {
            return "Unknown";
        }
        return stringArray[n - 1];
    }

    public static boolean needsReconnect(byte[] byArray) {
        int n = FileUtil.getDfuFileInformation((byte[])byArray).type_model;
        return FileUtil.isReconnect(n == 40 ? "BT966" : FileUtil.getModelName(n));
    }

    public static String hexToString(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            int n2 = n;
            n = n2 + 2;
            stringBuilder2.append((char)Integer.parseInt(string.substring(n2, n), 16));
        }
        return stringBuilder2.toString();
    }

    public static byte[] changeBytesEndian(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int k = 0; k < n; ++k) {
            byArray2[k] = byArray[n - k - 1];
        }
        return byArray2;
    }
}

