/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.ble.bean;

import android.util.SparseArray;
import androidx.annotation.Keep;
import java.util.HashMap;

@Keep
public class BleNamesResolver {
    private static final HashMap<String, String> mServices;
    private static final HashMap<String, String> mCharacteristics;
    private static final SparseArray<String> mValueFormats;
    private static final SparseArray<String> mAppearance;
    private static final SparseArray<String> mHeartRateSensorLocation;

    public static String resolveServiceName(String string) {
        if ((string = mServices.get(string)) == null) {
            string = "Unknown";
        }
        return string;
    }

    public static String resolveValueTypeDescription(int n) {
        return (String)mValueFormats.get(Integer.valueOf(n).intValue(), (Object)"Unknown Format");
    }

    public static String resolveCharacteristicName(String string) {
        if ((string = mCharacteristics.get(string)) == null) {
            string = "Unknown";
        }
        return string;
    }

    public static String resolveUuid(String string) {
        String string2 = mServices.get(string);
        if (string2 != null) {
            return "Service: " + string2;
        }
        if ((string = mCharacteristics.get(string)) != null) {
            return "Characteristic: " + string;
        }
        return "Unknown UUID";
    }

    public static String resolveAppearance(int n) {
        return (String)mAppearance.get(Integer.valueOf(n).intValue(), (Object)"Unknown Appearance");
    }

    public static String resolveHeartRateSensorLocation(int n) {
        return (String)mHeartRateSensorLocation.get(Integer.valueOf(n).intValue(), (Object)"Other");
    }

    public static boolean isService(String string) {
        return mServices.containsKey(string);
    }

    public static boolean isCharacteristic(String string) {
        return mCharacteristics.containsKey(string);
    }

    static {
        SparseArray sparseArray;
        SparseArray sparseArray2;
        SparseArray sparseArray3;
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2;
        HashMap<String, String> hashMap3 = hashMap2;
        mServices = new HashMap<String, String>();
        HashMap<String, String> hashMap4 = hashMap;
        mCharacteristics = new HashMap<String, String>();
        SparseArray sparseArray4 = sparseArray3;
        mValueFormats = new SparseArray();
        SparseArray sparseArray5 = sparseArray2;
        mAppearance = new SparseArray();
        SparseArray sparseArray6 = sparseArray;
        SparseArray sparseArray7 = sparseArray5;
        SparseArray sparseArray8 = sparseArray4;
        HashMap<String, String> hashMap5 = hashMap4;
        HashMap<String, String> hashMap6 = hashMap3;
        SparseArray sparseArray9 = sparseArray6;
        sparseArray9();
        mHeartRateSensorLocation = sparseArray9;
        hashMap6.put("00001811-0000-1000-8000-00805f9b34fb", "Alert Notification Service");
        hashMap6.put("0000180f-0000-1000-8000-00805f9b34fb", "Battery Service");
        hashMap6.put("00001810-0000-1000-8000-00805f9b34fb", "Blood Pressure");
        hashMap6.put("00001805-0000-1000-8000-00805f9b34fb", "Current Time Service");
        hashMap6.put("00001818-0000-1000-8000-00805f9b34fb", "Cycling Power");
        hashMap6.put("00001816-0000-1000-8000-00805f9b34fb", "Cycling Speed and Cadence");
        hashMap6.put("0000180a-0000-1000-8000-00805f9b34fb", "Device Information");
        hashMap6.put("00001800-0000-1000-8000-00805f9b34fb", "Generic Access");
        hashMap6.put("00001801-0000-1000-8000-00805f9b34fb", "Generic Attribute");
        hashMap6.put("00001808-0000-1000-8000-00805f9b34fb", "Glucose");
        hashMap6.put("00001809-0000-1000-8000-00805f9b34fb", "Health Thermometer");
        hashMap6.put("0000180d-0000-1000-8000-00805f9b34fb", "Heart Rate");
        hashMap6.put("00001812-0000-1000-8000-00805f9b34fb", "Human Interface Device");
        hashMap6.put("00001802-0000-1000-8000-00805f9b34fb", "Immediate Alert");
        hashMap6.put("00001803-0000-1000-8000-00805f9b34fb", "Link Loss");
        hashMap6.put("00001819-0000-1000-8000-00805f9b34fb", "Location and Navigation");
        hashMap6.put("00001807-0000-1000-8000-00805f9b34fb", "Next DST Change Service");
        hashMap6.put("0000180e-0000-1000-8000-00805f9b34fb", "Phone Alert Status Service");
        hashMap6.put("00001806-0000-1000-8000-00805f9b34fb", "Reference Time Update Service");
        hashMap6.put("00001814-0000-1000-8000-00805f9b34fb", "Running Speed and Cadence");
        hashMap6.put("00001813-0000-1000-8000-00805f9b34fb", "Scan Parameters");
        hashMap6.put("00001804-0000-1000-8000-00805f9b34fb", "Tx Power");
        hashMap5.put("00002a43-0000-1000-8000-00805f9b34fb", "Alert Category ID");
        hashMap5.put("00002a42-0000-1000-8000-00805f9b34fb", "Alert Category ID Bit Mask");
        hashMap5.put("00002a06-0000-1000-8000-00805f9b34fb", "Alert Level");
        hashMap5.put("00002a44-0000-1000-8000-00805f9b34fb", "Alert Notification Control Point");
        hashMap5.put("00002a3f-0000-1000-8000-00805f9b34fb", "Alert Status");
        hashMap5.put("00002a01-0000-1000-8000-00805f9b34fb", "Appearance");
        hashMap5.put("00002a19-0000-1000-8000-00805f9b34fb", "Battery Level");
        hashMap5.put("00002a49-0000-1000-8000-00805f9b34fb", "Blood Pressure Feature");
        hashMap5.put("00002a35-0000-1000-8000-00805f9b34fb", "Blood Pressure Measurement");
        hashMap5.put("00002a38-0000-1000-8000-00805f9b34fb", "Body Sensor Location");
        hashMap5.put("00002a22-0000-1000-8000-00805f9b34fb", "Boot Keyboard Input Report");
        hashMap5.put("00002a32-0000-1000-8000-00805f9b34fb", "Boot Keyboard Output Report");
        hashMap5.put("00002a33-0000-1000-8000-00805f9b34fb", "Boot Mouse Input Report");
        hashMap5.put("00002a5c-0000-1000-8000-00805f9b34fb", "CSC Feature");
        hashMap5.put("00002a5b-0000-1000-8000-00805f9b34fb", "CSC Measurement");
        hashMap5.put("00002a2b-0000-1000-8000-00805f9b34fb", "Current Time");
        hashMap5.put("00002a66-0000-1000-8000-00805f9b34fb", "Cycling Power Control Point");
        hashMap5.put("00002a65-0000-1000-8000-00805f9b34fb", "Cycling Power Feature");
        hashMap5.put("00002a63-0000-1000-8000-00805f9b34fb", "Cycling Power Measurement");
        hashMap5.put("00002a64-0000-1000-8000-00805f9b34fb", "Cycling Power Vector");
        hashMap5.put("00002a08-0000-1000-8000-00805f9b34fb", "Date Time");
        hashMap5.put("00002a0a-0000-1000-8000-00805f9b34fb", "Day Date Time");
        hashMap5.put("00002a09-0000-1000-8000-00805f9b34fb", "Day of Week");
        hashMap5.put("00002a00-0000-1000-8000-00805f9b34fb", "Device Name");
        hashMap5.put("00002a0d-0000-1000-8000-00805f9b34fb", "DST Offset");
        hashMap5.put("00002a0c-0000-1000-8000-00805f9b34fb", "Exact Time 256");
        hashMap5.put("00002a26-0000-1000-8000-00805f9b34fb", "Firmware Revision String");
        hashMap5.put("00002a51-0000-1000-8000-00805f9b34fb", "Glucose Feature");
        hashMap5.put("00002a18-0000-1000-8000-00805f9b34fb", "Glucose Measurement");
        hashMap5.put("00002a34-0000-1000-8000-00805f9b34fb", "Glucose Measurement Context");
        hashMap5.put("00002a27-0000-1000-8000-00805f9b34fb", "Hardware Revision String");
        hashMap5.put("00002a39-0000-1000-8000-00805f9b34fb", "Heart Rate Control Point");
        hashMap5.put("00002a37-0000-1000-8000-00805f9b34fb", "Heart Rate Measurement");
        hashMap5.put("00002a4c-0000-1000-8000-00805f9b34fb", "HID Control Point");
        hashMap5.put("00002a4a-0000-1000-8000-00805f9b34fb", "HID Information");
        hashMap5.put("00002a2a-0000-1000-8000-00805f9b34fb", "IEEE 11073-20601 Regulatory Certification Data List");
        hashMap5.put("00002a36-0000-1000-8000-00805f9b34fb", "Intermediate Cuff Pressure");
        hashMap5.put("00002a1e-0000-1000-8000-00805f9b34fb", "Intermediate Temperature");
        hashMap5.put("00002a6b-0000-1000-8000-00805f9b34fb", "LN Control Point");
        hashMap5.put("00002a6a-0000-1000-8000-00805f9b34fb", "LN Feature");
        hashMap5.put("00002a0f-0000-1000-8000-00805f9b34fb", "Local Time Information");
        hashMap5.put("00002a67-0000-1000-8000-00805f9b34fb", "Location and Speed");
        hashMap5.put("00002a29-0000-1000-8000-00805f9b34fb", "Manufacturer Name String");
        hashMap5.put("00002a21-0000-1000-8000-00805f9b34fb", "Measurement Interval");
        hashMap5.put("00002a24-0000-1000-8000-00805f9b34fb", "Model Number String");
        hashMap5.put("00002a68-0000-1000-8000-00805f9b34fb", "Navigation");
        hashMap5.put("00002a46-0000-1000-8000-00805f9b34fb", "New Alert");
        hashMap5.put("00002a04-0000-1000-8000-00805f9b34fb", "Peripheral Preferred Connection Parameters");
        hashMap5.put("00002a02-0000-1000-8000-00805f9b34fb", "Peripheral Privacy Flag");
        hashMap5.put("00002a50-0000-1000-8000-00805f9b34fb", "PnP ID");
        hashMap5.put("00002a69-0000-1000-8000-00805f9b34fb", "Position Quality");
        hashMap5.put("00002a4e-0000-1000-8000-00805f9b34fb", "Protocol Mode");
        hashMap5.put("00002a03-0000-1000-8000-00805f9b34fb", "Reconnection Address");
        hashMap5.put("00002a52-0000-1000-8000-00805f9b34fb", "Record Access Control Point");
        hashMap5.put("00002a14-0000-1000-8000-00805f9b34fb", "Reference Time Information");
        hashMap5.put("00002a4d-0000-1000-8000-00805f9b34fb", "Report");
        hashMap5.put("00002a4b-0000-1000-8000-00805f9b34fb", "Report Map");
        hashMap5.put("00002a40-0000-1000-8000-00805f9b34fb", "Ringer Control Point");
        hashMap5.put("00002a41-0000-1000-8000-00805f9b34fb", "Ringer Setting");
        hashMap5.put("00002a54-0000-1000-8000-00805f9b34fb", "RSC Feature");
        hashMap5.put("00002a53-0000-1000-8000-00805f9b34fb", "RSC Measurement");
        hashMap5.put("00002a55-0000-1000-8000-00805f9b34fb", "SC Control Point");
        hashMap5.put("00002a4f-0000-1000-8000-00805f9b34fb", "Scan Interval Window");
        hashMap5.put("00002a31-0000-1000-8000-00805f9b34fb", "Scan Refresh");
        hashMap5.put("00002a5d-0000-1000-8000-00805f9b34fb", "Sensor Location");
        hashMap5.put("00002a25-0000-1000-8000-00805f9b34fb", "Serial Number String");
        hashMap5.put("00002a05-0000-1000-8000-00805f9b34fb", "Service Changed");
        hashMap5.put("00002a28-0000-1000-8000-00805f9b34fb", "Software Revision String");
        hashMap5.put("00002a47-0000-1000-8000-00805f9b34fb", "Supported New Alert Category");
        hashMap5.put("00002a48-0000-1000-8000-00805f9b34fb", "Supported Unread Alert Category");
        hashMap5.put("00002a23-0000-1000-8000-00805f9b34fb", "System ID");
        hashMap5.put("00002a1c-0000-1000-8000-00805f9b34fb", "Temperature Measurement");
        hashMap5.put("00002a1d-0000-1000-8000-00805f9b34fb", "Temperature Type");
        hashMap5.put("00002a12-0000-1000-8000-00805f9b34fb", "Time Accuracy");
        hashMap5.put("00002a13-0000-1000-8000-00805f9b34fb", "Time Source");
        hashMap5.put("00002a16-0000-1000-8000-00805f9b34fb", "Time Update Control Point");
        hashMap5.put("00002a17-0000-1000-8000-00805f9b34fb", "Time Update State");
        hashMap5.put("00002a11-0000-1000-8000-00805f9b34fb", "Time with DST");
        hashMap5.put("00002a0e-0000-1000-8000-00805f9b34fb", "Time Zone");
        hashMap5.put("00002a07-0000-1000-8000-00805f9b34fb", "Tx Power Level");
        hashMap5.put("00002a45-0000-1000-8000-00805f9b34fb", "Unread Alert Status");
        sparseArray8.put(Integer.valueOf(52).intValue(), (Object)"32bit float");
        sparseArray8.put(Integer.valueOf(50).intValue(), (Object)"16bit float");
        sparseArray8.put(Integer.valueOf(34).intValue(), (Object)"16bit signed int");
        sparseArray8.put(Integer.valueOf(36).intValue(), (Object)"32bit signed int");
        sparseArray8.put(Integer.valueOf(33).intValue(), (Object)"8bit signed int");
        sparseArray8.put(Integer.valueOf(18).intValue(), (Object)"16bit unsigned int");
        sparseArray8.put(Integer.valueOf(20).intValue(), (Object)"32bit unsigned int");
        sparseArray8.put(Integer.valueOf(17).intValue(), (Object)"8bit unsigned int");
        sparseArray7.put(Integer.valueOf(833).intValue(), (Object)"Heart Rate Sensor: Belt");
        sparseArray7.put(Integer.valueOf(832).intValue(), (Object)"Generic Heart Rate Sensor");
        sparseArray7.put(Integer.valueOf(0).intValue(), (Object)"Unknown");
        sparseArray7.put(Integer.valueOf(64).intValue(), (Object)"Generic Phone");
        sparseArray7.put(Integer.valueOf(1157).intValue(), (Object)"Cycling: Speed and Cadence Sensor");
        sparseArray7.put(Integer.valueOf(1152).intValue(), (Object)"General Cycling");
        sparseArray7.put(Integer.valueOf(1153).intValue(), (Object)"Cycling Computer");
        sparseArray7.put(Integer.valueOf(1154).intValue(), (Object)"Cycling: Speed Sensor");
        sparseArray7.put(Integer.valueOf(1155).intValue(), (Object)"Cycling: Cadence Sensor");
        sparseArray7.put(Integer.valueOf(1156).intValue(), (Object)"Cycling: Speed and Cadence Sensor");
        sparseArray7.put(Integer.valueOf(1157).intValue(), (Object)"Cycling: Power Sensor");
        sparseArray.put(Integer.valueOf(0).intValue(), (Object)"Other");
        sparseArray.put(Integer.valueOf(1).intValue(), (Object)"Chest");
        sparseArray.put(Integer.valueOf(2).intValue(), (Object)"Wrist");
        sparseArray.put(Integer.valueOf(3).intValue(), (Object)"Finger");
        sparseArray.put(Integer.valueOf(4).intValue(), (Object)"Hand");
        sparseArray.put(Integer.valueOf(5).intValue(), (Object)"Ear Lobe");
        sparseArray.put(Integer.valueOf(6).intValue(), (Object)"Foot");
    }
}

