/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.logger;

import a.a.c.b;
import android.os.Environment;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.feasycom.logger.DiskLogStrategy;
import com.feasycom.logger.FormatStrategy;
import com.feasycom.logger.LogStrategy;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CsvFormatStrategy
implements FormatStrategy {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String NEW_LINE_REPLACEMENT = " <br> ";
    private static final String SEPARATOR = ",";
    @NonNull
    private final Date date;
    @NonNull
    private final SimpleDateFormat dateFormat;
    @NonNull
    private final LogStrategy logStrategy;
    @Nullable
    private final String tag;

    private CsvFormatStrategy(@NonNull Builder builder) {
        Builder builder2 = builder;
        b.a(builder2);
        this.date = builder2.date;
        this.dateFormat = builder.dateFormat;
        this.logStrategy = builder.logStrategy;
        this.tag = builder.tag;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(null);
    }

    @Nullable
    private String formatTag(@Nullable String string) {
        if (!b.a(string) && !b.a(this.tag, string)) {
            return this.tag + "-" + string;
        }
        return this.tag;
    }

    public /* synthetic */ CsvFormatStrategy(Builder builder, a a2) {
        this(builder);
    }

    @Override
    public void log(int n, @Nullable String string, @NonNull String string2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        CsvFormatStrategy csvFormatStrategy = this;
        b.a(string2);
        string = csvFormatStrategy.formatTag(string);
        csvFormatStrategy.date.setTime(System.currentTimeMillis());
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        StringBuilder stringBuilder5 = stringBuilder2;
        stringBuilder2();
        stringBuilder5.append(Long.toString(this.date.getTime()));
        stringBuilder5.append(SEPARATOR);
        stringBuilder4.append(this.dateFormat.format(this.date));
        stringBuilder4.append(SEPARATOR);
        stringBuilder3.append(b.a(n));
        stringBuilder3.append(SEPARATOR);
        stringBuilder.append(string);
        String string3 = NEW_LINE;
        if (string2.contains(string3)) {
            string2 = string2.replaceAll(string3, NEW_LINE_REPLACEMENT);
        }
        stringBuilder2.append(SEPARATOR);
        stringBuilder2.append(string2);
        stringBuilder2.append(string3);
        this.logStrategy.log(n, string, stringBuilder2.toString());
    }

    public static final class Builder {
        private static final int MAX_BYTES = 512000;
        public Date date;
        public SimpleDateFormat dateFormat;
        public LogStrategy logStrategy;
        public String tag = "PRETTY_LOGGER";

        private Builder() {
        }

        public /* synthetic */ Builder(a a2) {
            this();
        }

        @NonNull
        public Builder date(@Nullable Date date) {
            this.date = date;
            return this;
        }

        @NonNull
        public Builder dateFormat(@Nullable SimpleDateFormat simpleDateFormat) {
            this.dateFormat = simpleDateFormat;
            return this;
        }

        @NonNull
        public Builder logStrategy(@Nullable LogStrategy logStrategy) {
            this.logStrategy = logStrategy;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String string) {
            this.tag = string;
            return this;
        }

        @NonNull
        public CsvFormatStrategy build() {
            Object object;
            if (this.date == null) {
                Date date;
                object = date;
                date = new Date();
                this.date = object;
            }
            if (this.dateFormat == null) {
                SimpleDateFormat simpleDateFormat;
                object = simpleDateFormat;
                simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS", Locale.UK);
                this.dateFormat = object;
            }
            if (this.logStrategy == null) {
                DiskLogStrategy.a a2;
                HandlerThread handlerThread;
                object = Environment.getExternalStorageDirectory().getAbsolutePath();
                object = (String)object + File.separatorChar + "logger";
                HandlerThread handlerThread2 = handlerThread;
                new HandlerThread("AndroidFileLogger." + (String)object).start();
                DiskLogStrategy.a a3 = a2;
                a2 = new DiskLogStrategy.a(handlerThread2.getLooper(), (String)object, 512000);
                this.logStrategy = new DiskLogStrategy(a3);
            }
            return new CsvFormatStrategy(this, null);
        }
    }
}

