/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.wifi.utils;

import android.net.DhcpInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u0019\u00a2\u0006\u0004\b\n\u0010\u001eJ\u000f\u0010\u001f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b!\u0010 J\u0017\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u0013\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/feasycom/wifi/utils/NetUtils;", "", "Landroid/net/wifi/WifiInfo;", "info", "", "getRawSsidBytes", "(Landroid/net/wifi/WifiInfo;)[B", "", "isIPv4", "Ljava/net/InetAddress;", "getAddress", "(Z)Ljava/net/InetAddress;", "Landroid/net/wifi/WifiManager;", "wifiManager", "isWifiConnected", "(Landroid/net/wifi/WifiManager;)Z", "orElse", "getRawSsidBytesOrElse", "(Landroid/net/wifi/WifiInfo;[B)[B", "", "getSsidString", "(Landroid/net/wifi/WifiInfo;)Ljava/lang/String;", "wifi", "getBroadcastAddress", "(Landroid/net/wifi/WifiManager;)Ljava/net/InetAddress;", "", "frequency", "is5G", "(I)Z", "ipAddress", "(I)Ljava/net/InetAddress;", "getIPv4Address", "()Ljava/net/InetAddress;", "getIPv6Address", "bssid", "convertBssid2Bytes", "(Ljava/lang/String;)[B", "<init>", "()V", "feasybluelibrary_release"})
public final class NetUtils {
    @NotNull
    public static final NetUtils INSTANCE = new NetUtils();

    private NetUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] getRawSsidBytes(WifiInfo wifiInfo) {
        Object object;
        block11: {
            Class<?> clazz = wifiInfo.getClass();
            Method method = clazz.getMethod("getWifiSsid", new Class[0]);
            method.setAccessible(true);
            object = method.invoke((Object)wifiInfo, new Object[0]);
            if (object != null) break block11;
            return null;
        }
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod("getOctets", new Class[0]);
        method.setAccessible(true);
        object = method.invoke(object, new Object[0]);
        if (object == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
        try {
            return (byte[])object;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final InetAddress getAddress(boolean bl) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        block9: while (true) {
            if (!enumeration.hasMoreElements()) return null;
            Enumeration<InetAddress> enumeration = ((NetworkInterface)enumeration.nextElement()).getInetAddresses();
            while (true) {
                InetAddress inetAddress;
                block11: {
                    if (!enumeration.hasMoreElements()) continue block9;
                    inetAddress = enumeration.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (!bl) break block11;
                    if (!(inetAddress instanceof Inet4Address)) break block11;
                    return inetAddress;
                }
                if (bl) continue;
                if (inetAddress instanceof Inet6Address) return inetAddress;
                continue;
                break;
            }
            break;
        }
        return null;
    }

    public final boolean isWifiConnected(@NotNull WifiManager wifiManager) {
        WifiManager wifiManager2 = wifiManager;
        Intrinsics.checkNotNullParameter((Object)wifiManager2, (String)"wifiManager");
        NetUtils netUtils = wifiManager2.getConnectionInfo();
        return netUtils != null && netUtils.getNetworkId() != -1 && !Intrinsics.areEqual((Object)"<unknown ssid>", (Object)netUtils.getSSID());
    }

    @Nullable
    public final byte[] getRawSsidBytesOrElse(@NotNull WifiInfo wifiInfo, @Nullable byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)wifiInfo, (String)"info");
        byte[] byArray2 = ((NetUtils)object).getRawSsidBytes(wifiInfo);
        Object object = byArray2;
        if (byArray2 == null) {
            object = byArray;
        }
        return object;
    }

    @Nullable
    public final String getSsidString(@NotNull WifiInfo wifiInfo) {
        WifiInfo wifiInfo2 = wifiInfo;
        Intrinsics.checkNotNullParameter((Object)wifiInfo2, (String)"info");
        Object object = wifiInfo2.getSSID();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ssid");
        if (StringsKt.startsWith$default((String)object, (String)"\"", (boolean)false, (int)2, null)) {
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ssid");
            if (StringsKt.endsWith$default((String)object2, (String)"\"", (boolean)false, (int)2, null)) {
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"ssid");
                object = ((String)object3).substring(1, ((String)object3).length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
        }
        return object;
    }

    @Nullable
    public final InetAddress getBroadcastAddress(@NotNull WifiManager object) {
        WifiManager wifiManager = object;
        Intrinsics.checkNotNullParameter((Object)wifiManager, (String)"wifi");
        NetUtils netUtils = wifiManager.getDhcpInfo();
        if (netUtils != null) {
            int n = ((DhcpInfo)netUtils).netmask;
            n = ((DhcpInfo)netUtils).ipAddress & n | ~n;
            object = new byte[4];
            int n2 = 0;
            while (true) {
                int n3 = n2 + 1;
                object[n2] = (WifiManager)((byte)(n >> n2 * 8 & 0xFF));
                if (n3 > 3) {
                    try {
                        return InetAddress.getByAddress((byte[])object);
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace();
                        break;
                    }
                }
                n2 = n3;
            }
        }
        try {
            return InetAddress.getByName("255.255.255.255");
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return null;
        }
    }

    public final boolean is5G(int n) {
        return n > 4900 && n < 5900;
    }

    @Nullable
    public final InetAddress getAddress(int n) {
        byte[] byArray = new byte[4];
        Object object = byArray;
        object[0] = (byte)(n & 0xFF);
        object[1] = (byte)(n >> 8 & 0xFF);
        object[2] = (byte)(n >> 16 & 0xFF);
        byArray[3] = (byte)(n >> 24 & 0xFF);
        try {
            object = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            object = null;
        }
        return object;
    }

    @Nullable
    public final InetAddress getIPv4Address() {
        return this.getAddress(true);
    }

    @Nullable
    public final InetAddress getIPv6Address() {
        return this.getAddress(false);
    }

    @Nullable
    public final byte[] convertBssid2Bytes(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"bssid");
        String[] stringArray = new Regex(":").split((CharSequence)object, 0).toArray(new String[0]);
        if (stringArray != null) {
            if (stringArray.length == 6) {
                object = new byte[stringArray.length];
                int n = 0;
                int n2 = stringArray.length + -1;
                if (n2 >= 0) {
                    while (true) {
                        int n3 = n + 1;
                        object[n] = (byte)Integer.parseInt(stringArray[n], CharsKt.checkRadix((int)16));
                        if (n3 > n2) break;
                        n = n3;
                    }
                }
                return object;
            }
            throw new IllegalArgumentException("Invalid bssid format".toString());
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
    }
}

