package com.feasycom.feasyblue.activity

import android.content.Context
import android.content.Intent
import android.text.Editable
import android.text.TextWatcher
import android.view.KeyEvent
import com.feasycom.common.utils.MsgLogger
import com.feasycom.feasyblue.R
import com.feasycom.feasyblue.utils.getBoolean
import com.feasycom.feasyblue.utils.putBoolean
import kotlinx.android.synthetic.main.activity_password.*

class PasswordActivity: BaseActivity() {

    override fun initView() {
        setSupportActionBar(toolbar)
        supportActionBar?.let {
            it.setDisplayShowTitleEnabled(false);
            it.setDisplayHomeAsUpEnabled(true)
        }
        var type = intent.getIntExtra("type", 0)
        if (type==0){
            toolbarTitle.text = getString(R.string.parameterDefining)
            val isPasswordPara = getBoolean("isPasswordPara", false)
            if (isPasswordPara) {
                ParameterModificationActivity.activityStart(this@PasswordActivity)
                finish()
            }
        } else {
            toolbarTitle.text = getString(R.string.advanced_setting_text)
            val isPasswordEAdvance = getBoolean("isPasswordEAdvance", false)
            if (isPasswordEAdvance) {
                AdvancedSettingsListActivity.activityStart(this@PasswordActivity)
                finish()
            }
        }

        toolbar.setNavigationOnClickListener {
            MainActivity.activityStart(this, 1)
            finish()
        }

        passwordEditView.editText?.addTextChangedListener(object: TextWatcher{
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                if(s?.length == 8){
                    when (type) {
                        0 -> {
                            if (s.toString() == "20138888") {
                                putBoolean("isPasswordPara",true)
                                ParameterModificationActivity.activityStart(this@PasswordActivity)
                                finish()
                            } else {
                                passwordEditView.error = getString(R.string.password_error)
                            }
                        }
                        1 -> {
                            if (s.toString() == "20137777") {
                                putBoolean("isPasswordEAdvance",true)
                                AdvancedSettingsListActivity.activityStart(this@PasswordActivity)
                                finish()
                            } else {
                                passwordEditView.error = getString(R.string.password_error)
                            }
                        }
                    }

                }
            }

            override fun afterTextChanged(s: Editable?) {
                if (s?.length != 8){
                    passwordEditView.error = ""
                }
            }

        })

    }

    override fun getLayout() = R.layout.activity_password

    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {
        return if ((keyCode == KeyEvent.KEYCODE_BACK)) {
            MainActivity.activityStart(this, 1)
            finish()
            false
        }else {
            super.onKeyDown(keyCode, event);
        }
    }


    companion object{
        private const val TAG = "PasswordActivity"

        fun activityStart(context: Context, type: Int){
            val intent = Intent(context, PasswordActivity::class.java)
            intent.putExtra("type", type)
            context.startActivity(intent)
        }
    }
}