//
//  NSString+FscKit.h
//  BLEAssistant
//
//  Created by ericj on 2018/1/13.
//  Copyright © 2018年 feasycom. All rights reserved.
//

#import <Foundation/Foundation.h>

#define REVERSE16(v) (((uint16_t)(v) << 8) | ((uint16_t)(v) >> 8))

@interface NSString (FscKit)


//十进制转十六进制
+ (NSString *)stringToHexString:(uint32_t)number;
// 十六进制数据转字符串
+ (NSString *)fan_dataToHexString:(NSData *)data;
// 转换地址头部
+ (NSString *)transformAddressHandString:(NSString *)string;
// 地址解析
+ (NSString *)getAddress:(NSString *)string;
// 反转地址头部
+ (NSString *)getAddressHandString:(NSString *)string;
// 后缀->16进制
+ (NSString *)tailStringToHexString:(NSString *)string;
// 16进制字符串->网址
+ (NSString *)getAddressFromHexString:(NSString *)string;
// 网址->16进制字符串
+ (NSString *)HexConvertToASCII:(NSString *)hexString;
//将uint32_t转换成十六进制的字符串
+ (NSString *)stringWithHexNumber:(uint32_t)hexNumber;
//十进制转换十六进制
+ (NSString *)getHexByDecimal:(unsigned int)decimal;
// 转换地址尾部
+ (NSString *)getAddressTailString:(NSString *)string;
// 模块型号
+ (NSString *)modelForFirmwareValue:(int)value;
+ (NSString *)modelForBroadcastValue:(int)value;
//获取bundle版本
+ (NSString *)getLocalAppVersion;

+ (NSString *)getNowTimeTimestamp;

- (NSInteger)integerFromReverseString;

- (NSString *)decryptVersion;

- (NSString *)moduleFromHexString;

- (BOOL)isDigits;

- (BOOL)isUnsignedDigits;

- (BOOL)isHexDigits;

@end


