//
//  FWRootViewController.m
//  FeasyBeacon
//
//  Created by LIDONG on 14-2-28.
//  Copyright (c) 2014年 LIDONG. All rights reserved.
//

#import "FWRootViewController.h"

@interface FWRootViewController ()
@property (nonatomic, strong) NSMutableArray *viewControllerArr;
@end

@implementation FWRootViewController

- (id)init {
    self = [super initWithNibName:nil bundle:nil];
    if (self) {
        self.viewControllerArr = [NSMutableArray array];
        
        [self addViewController:@"FWBeaconsViewController"];// Beacon列表
        [self addViewController:@"FWSensorViewController"];// 传感器列表
        [self addViewController:@"FWSettingsViewController"];// 设备列表
        [self addViewController:@"FWStoreViewController"];// 商城
        [self addViewController:@"FWAboutVC"];// 关于
        
        [self setViewControllers:self.viewControllerArr];
    }
    return self;
}

- (void)addViewController:(NSString *)className {
    UIViewController *viewController = [[NSClassFromString(className) alloc] init];
    UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:viewController];
    
    [self.viewControllerArr addObject:navigationController];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation {
    return (UIInterfaceOrientationPortrait == toInterfaceOrientation);
}

- (BOOL)shouldAutorotate {
    return NO;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait;
}

@end
