//
//  PDFDocumentView.h
//  PDFReader
//
//  Created by Dong Li on 12-4-8.
//  Copyright (c) 2013年 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <QuartzCore/QuartzCore.h>
#import "IFZoomView.h"

@class PDFTiledView;

typedef struct __PDFPageInfo {
    CGPDFPageRef page;
    CGRect rect;
    CGFloat rotate;
    __unsafe_unretained PDFTiledView *view;
} PDFPageInfo;

@class PDFControlView;

@protocol PDFControlViewDelegate <NSObject>
@required
- (void)controlView:(PDFControlView *)controlView didScrollToPage:(NSInteger)page ratio:(CGFloat)ratio;
@end

@interface PDFControlView : IFZoomView <UIScrollViewDelegate> {
    UIView *_layoutView;
    CGPDFDocumentRef _PDFDocument;
    PDFPageInfo *_pageInfos;
    NSInteger _numberOfPages;
    NSInteger _currentPageIndex;
    CGSize _initialSize;
    __weak id<PDFControlViewDelegate> _controlViewDelegate;
}

@property (nonatomic, assign, readonly) NSInteger numberOfPages;
@property (nonatomic, weak) id<PDFControlViewDelegate> controlViewDelegate;

- (id)initWithFrame:(CGRect)frame document:(CGPDFDocumentRef)document;

@end
