//
//  PDFSlider.h
//  iFileReader
//
//  Created by LiDong on 13-4-7.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <UIKit/UIKit.h>

@class PDFSlider;

@protocol PDFSliderDelegate <NSObject>

- (void)sliderDidBeginDragging:(PDFSlider *)slider;
- (void)sliderWillEndDragging:(PDFSlider *)slider;
- (void)slider:(PDFSlider *)slider didChangeValue:(CGFloat)value;

@end

@interface PDFSlider : UIView {
    UIView *_thumbView;
    CGRect _iconRect;
    CGFloat _trackHeight;
    CGFloat _value;
    __weak id<PDFSliderDelegate> _delegate;
    BOOL _dragging;
}

@property (nonatomic, assign) CGFloat value;
@property (nonatomic, weak) id<PDFSliderDelegate> delegate;

@end
