//
//  PhotoScrollView.m
//  PDFReader
//
//  Created by Dong Li on 12-5-2.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "PhotoScrollView.h"
#import "GIFDecoder.h"
#import <QuartzCore/QuartzCore.h>


@implementation PhotoScrollView

- (id)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setBackgroundColor:UIColorBlack];
        [self setShowsVerticalScrollIndicator:NO];
        [self setShowsHorizontalScrollIndicator:NO];
        [self setBounces:YES];
        [self setAlwaysBounceHorizontal:YES];
        [self setAlwaysBounceVertical:YES];
        [self setBouncesZoom:YES];
        
        _imageView = [[UIImageView alloc] initWithFrame:CGRectZero];
        
        [self addSubview:_imageView];
    }
    return self;
}

- (void)dealloc {
}

- (void)layoutSubviews {
    // center the image as it becomes smaller than the size of the screen
    CGSize boundsSize = self.bounds.size;
    CGRect frameToCenter = [_imageView frame];
    
    // center horizontally
    if (frameToCenter.size.width < boundsSize.width) {
        frameToCenter.origin.x = (boundsSize.width - frameToCenter.size.width) / 2;
    } else {
        frameToCenter.origin.x = 0;
    }
    
    // center vertically
    if (frameToCenter.size.height < boundsSize.height) {
        frameToCenter.origin.y = (boundsSize.height - frameToCenter.size.height) / 2;
    } else {
        frameToCenter.origin.y = 0;
    }
    
    [_imageView setFrame:frameToCenter];
}

- (UIImage *)image {
    NSArray *animationImages = [_imageView animationImages];
    
    if (0 < [animationImages count]) {
        return [animationImages objectAtIndex:0];
    }
    return [_imageView image];
}

- (void)setImage:(UIImage *)image {
    if ([_imageView isAnimating]) {
        [_imageView stopAnimating];
        [_imageView setAnimationImages:nil];
    }
    
    if (image) {
        const CGRect bounds = [self bounds];
        const CGSize imageSize = [image size];
        const CGFloat scaleX = bounds.size.width / imageSize.width;
        const CGFloat scaleY = bounds.size.height / imageSize.height;
        
        CGFloat minScale = (scaleX < scaleY) ? scaleX : scaleY;
        
        minScale = (minScale < 1.f) ? minScale : 1.f;
        
        const CGSize contentSize = { imageSize.width * minScale, imageSize.height * minScale };
        const CGRect imageFrame = { (bounds.size.width - contentSize.width) / 2.f, (bounds.size.height - contentSize.height) / 2.f, contentSize.width, contentSize.height };
        
        [_imageView setFrame:imageFrame];
        [self setContentSize:contentSize];
    }
    
    [_imageView setImage:image];
}

- (void)setImages:(NSArray *)images duration:(NSTimeInterval)duration {
    const NSUInteger numberOfImages = [images count];
    
    if (0 < numberOfImages) {
        [self setImage:[images objectAtIndex:0]];
        
        if (numberOfImages > 1) {
            [_imageView setAnimationImages:images];
            [_imageView setAnimationDuration:duration];
            [_imageView startAnimating];
        }
    }
}

#pragma mark - UIScrollViewDelegate

- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView {
    return _imageView;
}

@end
