//
//  PSEncodingViewController.m
//  iFileReader
//
//  Created by LiDong on 13-4-11.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "PSEncodingViewController.h"

@interface PSEncodingViewController () {
}

@end

@implementation PSEncodingViewController


- (id)initWithTextStyle:(UITextStyleSettings *)textStyle {
    if (self = [super init]) {
        _textStyle = textStyle;
        
        [self setTitle:LS(@"ENCODING")];
        
        UIBarButtonItem *doneItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(onDone)];
        
        [[self navigationItem] setRightBarButtonItem:doneItem];
        UIBarButtonItem *flexibleItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:nil action:NULL];
        NSArray *toolbarItems = [[NSArray alloc] initWithObjects:flexibleItem, _rotationItem, nil];
        
        [self setToolbarItems:toolbarItems];
        _allEncodingNames = UISettingsGetAllEncodingNames();
        _selectedIndex = UISettingsGetIndexForEncoding([_textStyle encoding]);
    }
    return self;
}

- (void)loadView {
    _tableView = [[UITableView alloc] initWithFrame:CGRectPortraitLongVC style:UITableViewStyleGrouped];
    [_tableView setDataSource:self];
    [_tableView setDelegate:self];
    [_tableView setRowHeight:44];
    
    [self setView:_tableView];
}

- (void)viewWillAppear:(BOOL)animated {
    if (_selectedIndex < [_allEncodingNames count]) {
        [_tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:_selectedIndex inSection:0] atScrollPosition:UITableViewScrollPositionMiddle animated:NO];
    }
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [_textStyle setEncoding:UISettingsGetCFStringEncodingForIndex(_selectedIndex)];
}

- (void)releaseSubviews {
    _tableView = nil;
}

- (void)dealloc {
    }

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	return [_allEncodingNames count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath  {
    UILabel *textLabel = nil;
    const NSInteger row = [indexPath row];
    static NSString *CellIdentifier = @"PSFontCell";
	UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
	
	if (nil == cell) {
		cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
        [cell setSelectionStyle:UITableViewCellSelectionStyleGray];
        textLabel = [cell textLabel];
        
        [textLabel setFont:UIFontBold16];
	} else {
        textLabel = [cell textLabel];
    }
    
    [textLabel setText:[_allEncodingNames objectAtIndex:row]];
    [cell setAccessoryType:(row == _selectedIndex ? UITableViewCellAccessoryCheckmark : UITableViewCellAccessoryNone)];
    
	return cell;
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    const NSInteger row = [indexPath row];
    UITableViewCell *deselectedCell = [_tableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:_selectedIndex inSection:0]];
    UITableViewCell *selectedCell = [_tableView cellForRowAtIndexPath:indexPath];
    
    [deselectedCell setAccessoryType:UITableViewCellAccessoryNone];
    [selectedCell setAccessoryType:UITableViewCellAccessoryCheckmark];
    
    _selectedIndex = row;
    
    [_tableView deselectRowAtIndexPath:indexPath animated:YES];
}

#pragma mark - Action

- (void)onDone {
    [_textStyle setEncoding:UISettingsGetCFStringEncodingForIndex(_selectedIndex)];
    [_textStyle save];
    [[self navigationController] dismissViewControllerAnimated:YES completion:NULL];
}

@end
