//
//  UISettings.h
//  Downloader
//
//  Created by hxhg-LiDong on 13-1-30.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UITextStyleSettings.h"

////////////////////////////////////////////////////////////////////////////////
// constants

#define XATTR_DEFAULT (XATTR_NOFOLLOW | XATTR_SHOWCOMPRESSION)

typedef enum __FSSortingMode : char {
    SORT_BY_NAME,
    SORT_BY_DATE,
    SORT_BY_KIND,
    SORT_BY_SIZE
} FSSortingMode;


typedef NSComparisonResult FSSortingOrder;

////////////////////////////////////////////////////////////////////////////////
// intitialize / finalize

extern void UISettingsInitialize(void);
extern void UISettingsSynchronize(void);
extern void UISettingsFinalize(void);

////////////////////////////////////////////////////////////////////////////////
// orientation

extern void UISettingsLockOrientation(const BOOL flag);
extern BOOL UISettingsOrientationIsLocked(void);
extern BOOL UISettingsOrientationInvertLocked(void);
extern BOOL UISettingsShouldRotateToInterfaceOrientation(UIInterfaceOrientation interfaceOrientation);
extern UIInterfaceOrientationMask UISettingsSupportedInterfaceOrientation(void);

////////////////////////////////////////////////////////////////////////////////
// file extension

extern BOOL UISettingsShowFileExtensions(void);
extern void UISettingsSetShowFileExtensions(const BOOL flag);
extern BOOL UISettingsInvertShowFileExtensions(void);

////////////////////////////////////////////////////////////////////////////////
// sorting

extern FSSortingMode UISettingsGetSortingMode(void);
extern void UISettingsSetSortingMode(const FSSortingMode mode);
extern FSSortingOrder UISettingsGetSortingOrder(void);
extern void UISettingsSetSortingOrder(const FSSortingOrder order);
extern void UISettingsSetSortingData(const FSSortingMode mode, const FSSortingOrder order);

////////////////////////////////////////////////////////////////////////////////
// encoding

extern UInt8 UISettingsGetEncodingIndex(void);
extern void UISettingsSetEncodingIndex(const UInt8 index);

////////////////////////////////////////////////////////////////////////////////
// txt font

extern NSString *UISettingsGetFontName(void);
extern void UISettingsSetFontName(NSString *fontName);
extern NSString *UISettingsGetDisplayNameForFontNamed(NSString *fontName);
extern NSString *UISettingsGetFontDisplayName(void);
extern UIFont *UISettingsGetFont(void);
extern UIFont *UISettingsGetFontForSubTitle(void);
extern UInt8 UISettingsGetFontSize(void);
extern void UISettingsSetFontSize(const UInt8 size);

////////////////////////////////////////////////////////////////////////////////
// web browser

extern NSString *UISettingsGetHomePage(void);
extern void UISettingsSetHomePage(NSString *URLString);
