//
//  UITextStyleSettings.h
//  iFileReader
//
//  Created by LiDong on 13-4-11.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <Foundation/Foundation.h>

#define kNumberOfEncodings 86
#define NSFileExtendedAttributes @"NSFileExtendedAttributes"

extern UInt8 UISettingsGetIndexForEncoding(const CFStringEncoding encoding);
extern NSStringEncoding UISettingsGetCFStringEncoding();
extern NSStringEncoding UISettingsGetNSStringEncoding();
extern CFStringEncoding UISettingsGetCFStringEncodingForIndex(const UInt8 index);
extern NSStringEncoding UISettingsGetNSStringEncodingForIndex(const UInt8 index);
extern void UISettingsSetCFStringEncoding(const CFStringEncoding encoding);

extern NSString *UISettingsGetEncodingNameForIndex(const UInt8 index);
extern NSString *UISettingsGetEncodingNameForCFStringEncoding(const CFStringEncoding encoding);
extern NSString *UISettingsGetEncodingName(void);
extern NSArray *UISettingsGetAllEncodingNames(void);

@class FSFileItem;

@interface UITextStyleSettings : NSObject {
    CFStringEncoding _encoding;
    UInt32 _fontSize;
    NSString *_fontName;
    NSString *_fontDisplayName;
    NSString *_filePath;
}

@property (nonatomic, assign) CFStringEncoding encoding;
@property (nonatomic, assign) UInt32 fontSize;
@property (nonatomic, retain) NSString *fontName;
@property (nonatomic, retain, readonly) NSString *fontDisplayName;
@property (nonatomic, retain) NSString *filePath;

- (id)initWithPath:(NSString *)path;
- (UIFont *)font;
- (UIFont *)fontForSubTitle;
- (NSDictionary *)fileAttributes;
- (void)save;

@end
