//
//  Utilities.h
//  PushSDK
//
//  Created by LiDong on 12-9-6.
//  Copyright (c) 2013年 HXHG. All rights reserved.
//

#ifndef __UTILITIES_H__
#define __UTILITIES_H__


#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////
// structure

extern CGRect CGRectPortraitScreen;
extern CGRect CGRectPortraitLongVC;
extern CGRect CGRectPortraitShortVC;
extern CGRect CGRectLandscapeScreen;
extern CGRect CGRectLandscapeLongVC;
extern CGRect CGRectLandscapeShortVC;

extern UIColor *UIColorClear;
extern UIColor *UIColorWhite;
extern UIColor *UIColorBlack;
extern UIColor *UIColorGray;
extern UIColor *UIColorDarkGray;
extern UIColor *UIColorLightGray;
extern UIColor *UIColorDarkCyan;
extern UIColor *UIColorPDFBackground;
extern UIColor *UIColorTexturedBackground;
extern UIColor *UIColorViewFlipsideBackground;
extern UIColor *UIColorSelectedBackground;

extern CGColorRef CGColorClear;
extern CGColorRef CGColorWhite;
extern CGColorRef CGColorBlack;
extern CGColorRef CGColorGray;
extern CGColorRef CGColorDarkGray;
extern CGColorRef CGColorLightGray;
extern CGColorRef CGColorDarkCyan;
extern CGColorRef CGColorPDFBackground;
extern CGColorRef CGColorTexturedBackground;
extern CGColorRef CGColorViewFlipsideBackground;
extern CGColorRef CGColorSelectedBackground;

extern UIFont *UIFontNormal10;
extern UIFont *UIFontNormal12;
extern UIFont *UIFontNormal14;
extern UIFont *UIFontNormal16;
extern UIFont *UIFontBold10;
extern UIFont *UIFontBold12;
extern UIFont *UIFontBold14;
extern UIFont *UIFontBold16;
extern UIFont *UIFontBold18;

////////////////////////////////////////////////////////////////////////////////
// global variable

extern NSString * const NSStringEmpty;
extern NSString * const NSStringBlank;

extern NSString * FSDocumentsDirectory;
extern NSString * FSDownloadsDirectory;
extern NSString * FSLibraryDirectory;
extern NSString * FSTmpDownloadsDirectory;
extern NSString * FSTmpArchiveDirectory;
extern NSString * FSTmpUnarchiveDirectory;
extern NSString * FSTmpEmailDirectory;

extern NSFileManager *theFileManager;
extern NSDateFormatter *NSMainDateFormatter;

extern const CGFloat CGRadianPerDegree;

extern UIApplication *theApplication;


////////////////////////////////////////////////////////////////////////////////
// global function

extern void UIAlert(NSString *title, NSString *message);
extern UIBarButtonItem *UIBarButtonItemCreateFlat(NSString *imageName, id target, SEL action);
extern NSArray *NSLocalHostNames(void);
extern NSString *FSPathForNewFileInDirectory(NSString *directory, NSString *fileName, NSString *extension);
extern NSString *FSStringCreateWithFileSize(const UInt64 size);
extern CGPoint CGRectGetCenter(CGRect rect);
extern UIImage *UIBarStyledImageNamed(NSString *imageName);


////////////////////////////////////////////////////////////////////////////////

#define SIZE_1_KB 1024
#define SIZE_64_KB 65536
#define SIZE_128_KB 131072
#define SIZE_1_MB 1048576
#define SIZE_1_GB 1073741824


////////////////////////////////////////////////////////////////////////////////

#define NSBundleIdentifierKey (NSString *)kCFBundleIdentifierKey
#define NSBundleVersionKey (NSString *)kCFBundleVersionKey


////////////////////////////////////////////////////////////////////////////////

#define UIColorCreateGenericRGBA(r, g, b, a) [[UIColor alloc] initWithRed:r green:g blue:b alpha:a]
#define UIColorCreateGenericRGB(r, g, b) UIColorCreateGenericRGBA(r, g, b, 1.f)
#define	RGBA(r, g, b, a) UIColorCreateGenericRGBA(r, g, b, a)
#define	RGB(r, g, b) UIColorCreateGenericRGB(r, g, b)



////////////////////////////////////////////////////////////////////////

#define RND(x) (int)((x) + 0.5)
#define RX(r) r.origin.x
#define RY(r) r.origin.y
#define RW(r) r.size.width
#define RH(r) r.size.height
#define RMX(r) (RX(r) + RW(r) / 2.f)
#define RMY(r) (RY(r) + RH(r) / 2.f)
#define PT(x, y) (CGPoint){ (x), (y) }
#define CTR(r) PT(RMX(r), RMY(r))
#define SZ(w, h) (CGSize){ (w), (h) }
#define RECT(x, y, w, h) (CGRect){ (x), (y), (w), (h) }
#define EDGE(t, l, b, r) (UIEdgeInsets){ (t), (l), (b), (r) }


////////////////////////////////////////////////////////////////////////

#define LS(key) NSLocalizedString(key, nil)


////////////////////////////////////////////////////////////////////////

#define IMG(name) [UIImage imageNamed:name]
#define RESIZABLE_IMG(imageName, edge) [[UIImage imageNamed:imageName] resizableImageWithCapInsets:edge]


////////////////////////////////////////////////////////////////////////

#define UIFlxNone              UIViewAutoresizingNone
#define UIFlxWidth             UIViewAutoresizingFlexibleWidth
#define UIFlxHeight            UIViewAutoresizingFlexibleHeight
#define UIFlxLeft              UIViewAutoresizingFlexibleLeftMargin
#define UIFlxRight             UIViewAutoresizingFlexibleRightMargin
#define UIFlxTop               UIViewAutoresizingFlexibleTopMargin
#define UIFlxBottom            UIViewAutoresizingFlexibleBottomMargin
#define UIFlxSize              (UIFlxWidth | UIFlxHeight)
#define UIFlxHorizontalMargins (UIFlxLeft | UIFlxRight)
#define UIFlxVerticalMargins   (UIFlxTop | UIFlxBottom)
#define UIFlxAllMargins        (UIFlxHorizontalMargins | UIFlxVerticalMargins)


#endif // __UTILITIES_H__
