//
//  ZipArchive.h
//  
//
//  Created by aish on 08-9-11.
//  acsolu@gmail.com
//  Copyright 2008  Inc. All rights reserved.
//
// History: 
//    09-11-2008 version 1.0    release
//    10-18-2009 version 1.1    support password protected zip files
//    10-21-2009 version 1.2    fix date bug

#import <UIKit/UIKit.h>

#import "zip.h"
#import "unzip.h"

@class ZipCoder;

#define kZipBufferSize SIZE_1_MB

@interface ZipCoder : NSObject {
@private
	zipFile _zipFile;
	unzFile _unzFile;
    char _buffer[kZipBufferSize];
    NSString *_zipFilePath;
	NSString *_password;
}

- (BOOL)zipCreateFilAtPath:(NSString *)path;
- (BOOL)zipCreateFilAtPath:(NSString *)path password:(NSString *)password;
- (BOOL)zipAddSourceFileAtPath:(NSString *)file newName:(NSString *)newName inOperation:(NSOperation *)operation;
- (BOOL)zipClose;

- (BOOL)unzipOpenFileAtPath:(NSString *)zipFile;
- (BOOL)unzipOpenFileAtPath:(NSString *)zipFile password:(NSString *)password;
- (BOOL)unzipFileToPath:(NSString *)path allowOverwrite:(BOOL)allowOverwrite inOperation:(NSOperation *)operation;
- (BOOL)unzipClose;

@end
