//
//  FBForumController.m
//  FeasyBeacon
//
//  Created by chenchanghua on 2025/10/15.
//  Copyright © 2025 Feasycom. All rights reserved.
//

#import "FBForumController.h"
#import <WebKit/WebKit.h>
#import <AFNetworking/AFNetworking.h>
#define forumfeasycom @"https://forum.feasycom.com/"

@interface FBForumController () <WKNavigationDelegate,WKUIDelegate>
@property (nonatomic, strong) WKWebView *webView;
@property (nonatomic, strong) UIProgressView *progressView;//进度条
@end

@implementation FBForumController

- (id)init {
    self = [super init];
    if (self) {
        
        UITabBarItem *tabBarItem = [[UITabBarItem alloc] initWithTitle:LS(@"Forum") image:[UIImage imageNamed:@"forum"] tag:0];
        
        [self setTabBarItem:tabBarItem];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    if (@available(iOS 13.0, *)) {
        NSDictionary *dic = @{NSForegroundColorAttributeName : [UIColor whiteColor],
                              NSFontAttributeName : [UIFont systemFontOfSize:18 weight:UIFontWeightMedium]};
        
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = [UIColor darkGrayColor];
        appearance.titleTextAttributes = dic;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance = appearance;
    }
    //透明
    self.navigationController.navigationBar.translucent = YES;
    //navigation控件颜色
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
    self.title = LS(@"Forum");;
    
    [self setback];
    self.webView = [[WKWebView alloc] initWithFrame:CGRectMake(0, kNavBar_Height, self.view.frame.size.width, self.view.frame.size.height - kNavBar_Height - kTabBar_Height)];
    self.webView.navigationDelegate = self;
    [self.view addSubview:self.webView];
    NSURL *url = [NSURL URLWithString:forumfeasycom];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [self.webView loadRequest:request];
    
    self.progressView = [[UIProgressView alloc] initWithFrame:CGRectMake(0, kNavBar_Height, [[UIScreen mainScreen] bounds].size.width, 2)];
    //设置进度条的高度，下面这句代码表示进度条的宽度变为原来的1倍，高度变为原来的1.5倍.
    self.progressView.transform = CGAffineTransformMakeScale(1.0f, 1.5f);
    [self.view addSubview:self.progressView];
    //添加KVO，WKWebView有一个属性estimatedProgress，就是当前网页加载的进度，所以监听这个属性。
    [self.webView addObserver:self forKeyPath:@"estimatedProgress" options:NSKeyValueObservingOptionNew context:nil];
}

- (void)dealloc {
    [self.webView removeObserver:self forKeyPath:@"estimatedProgress"];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary<NSString *,id> *)change context:(void *)context {
    if ([keyPath isEqualToString:@"estimatedProgress"]) {
        self.progressView.progress = self.webView.estimatedProgress;
        if (self.progressView.progress == 1) {
            /*
             *添加一个简单的动画，将progressView的Height变为1.4倍，在开始加载网页的代理中会恢复为1.5倍
             *动画时长0.25s，延时0.3s后开始动画
             *动画结束后将progressView隐藏
             */
            __weak typeof (self)weakSelf = self;
            [UIView animateWithDuration:0.25f delay:0.3f options:UIViewAnimationOptionCurveEaseOut animations:^{
                weakSelf.progressView.transform = CGAffineTransformMakeScale(1.0f, 1.4f);
            } completion:^(BOOL finished) {
                weakSelf.progressView.hidden = YES;
            }];
        }
    } else {
        [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
    }
}

//开始加载
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation {
    NSLog(@"开始加载网页");
    //开始加载网页时展示出progressView
    self.progressView.hidden = NO;
    //开始加载网页的时候将progressView的Height恢复为1.5倍
    self.progressView.transform = CGAffineTransformMakeScale(1.0f, 1.5f);
    //防止progressView被网页挡住
    [self.view bringSubviewToFront:self.progressView];
}

//加载失败
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error {
    NSLog(@"加载失败");
}

- (void)setback {
    UIButton *button = [[UIButton alloc]initWithFrame:CGRectMake(10, 10, 54, 54)];
    [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [button setImage:[UIImage imageNamed:@"shuaxin-2"] forState:UIControlStateNormal];
    [button addTarget:self action:@selector(rightClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *right = [[UIBarButtonItem alloc] initWithCustomView:button];
    self.navigationItem.rightBarButtonItem  = right;
}

- (void)createAlertController:(NSString *)string {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:string message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:LS(@"OK") style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    [alertController addAction:okAction];
    [self.navigationController presentViewController:alertController animated:YES completion:NULL];
}

- (void)rightClick {
    if ([[AFNetworkReachabilityManager sharedManager] networkReachabilityStatus] <= AFNetworkReachabilityStatusNotReachable) {
        [self createAlertController:LS(@"NETWORK_NOT_REACHABLE")];
        return;
    }
    NSURL *url = [NSURL URLWithString:forumfeasycom];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [self.webView loadRequest:request];
}

- (void)setLeftNav {
    UIButton *backBtn = [[UIButton alloc]initWithFrame:CGRectMake(0, 0, 44, 44)];
    [backBtn setImage:[UIImage imageNamed:@"返回"] forState:UIControlStateNormal];
    [backBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(backBtnClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *barButton = [[UIBarButtonItem alloc]initWithCustomView:backBtn];
    
    UIButton *closeBtn = [[UIButton alloc]initWithFrame:CGRectMake(0, 0, 44, 44)];
    [closeBtn setImage:[UIImage imageNamed:@"shanchu-2"] forState:UIControlStateNormal];
    [closeBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
    [closeBtn addTarget:self action:@selector(closeBtnClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *closeBarButton = [[UIBarButtonItem alloc]initWithCustomView:closeBtn];
    
    self.navigationItem.leftBarButtonItems= @[barButton,closeBarButton];
}

- (void)backBtnClick {
    if (self.webView.canGoBack) {
        [self setLeftNav];
        [self.webView goBack];
    } else {
        self.navigationItem.leftBarButtonItems = nil;
    }
}

- (void)closeBtnClick {
    self.navigationItem.leftBarButtonItems = nil;
    if (self.webView.backForwardList.backList.count > 0) {                                  //得到栈里面的list
        WKBackForwardListItem * item = self.webView.backForwardList.currentItem;          //得到现在加载的list
        for (WKBackForwardListItem * backItem in self.webView.backForwardList.backList) { //循环遍历，得到你想退出到
            //添加判断条件
            [self.webView goToBackForwardListItem:self.webView.backForwardList.backList.firstObject];
        }
    }
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation {
    if (webView.canGoBack) {
        [self setLeftNav];
    } else {
        self.navigationItem.leftBarButtonItems = nil;
    }
}

- (void)webView:(WKWebView *)webView
decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction
decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler
{
    NSString *urlString = navigationAction.request.URL.absoluteString ?: @"";
    NSLog(@"开始请求：%@\n", navigationAction.request);
    NSLog(@"navigationAction: %@\n", navigationAction);
    NSLog(@"urlString: %@", urlString);
    NSLog(@"navigationAction.navigationType = %ld", (long)navigationAction.navigationType);
    
    // 1) 业务拦截：命中 /link.html 一律拦截
    if ([urlString containsString:@"/link.html"]) {
        decisionHandler(WKNavigationActionPolicyCancel);
        return;
    }
    
    // 2) 处理 target="_blank" 或非主 frame 导航：改为在当前 webView 打开
    if (navigationAction.targetFrame == nil || !navigationAction.targetFrame.isMainFrame) {
        [webView loadRequest:navigationAction.request];
        decisionHandler(WKNavigationActionPolicyCancel); // 取消“新窗口”这次导航
        return;
    }
    
    // 3) 其他正常放行
    decisionHandler(WKNavigationActionPolicyAllow);
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    self.navigationController.navigationBar.barStyle = UIStatusBarStyleLightContent;
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
}

@end

