//
//  PDFSlider.m
//  iFileReader
//
//  Created by LiDong on 13-4-7.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "PDFSlider.h"
#import <QuartzCore/QuartzCore.h>

@implementation PDFSlider

@synthesize delegate = _delegate;
@synthesize value = _value;

- (id)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setBackgroundColor:UIColorClear];
        [self setClipsToBounds:YES];
        [self setAutoresizesSubviews:NO];
        [self setAutoresizingMask:UIViewAutoresizingNone];
        [self setUserInteractionEnabled:YES];
        [self setExclusiveTouch:NO];
        
        _thumbView = [[UIView alloc] initWithFrame:CGRectZero];
        [_thumbView setBackgroundColor:UIColorClear];
        [_thumbView setClipsToBounds:YES];
        
        CALayer *thumbLayer = [_thumbView layer];
        
        [thumbLayer setBackgroundColor:[RGBA(0.f, 0.f, 0.f, 0.5f) CGColor]];
        [thumbLayer setBorderColor:[RGBA(0.9f, 0.9f, 0.9f, 0.75f) CGColor]];
        [thumbLayer setBorderWidth:1.f];
        [thumbLayer setCornerRadius:7];
        [thumbLayer setShadowColor:[UIColorClear CGColor]];
        [thumbLayer setShadowOffset:CGSizeZero];
        
        [self addSubview:_thumbView];
        
        _iconRect.size.width = 14;
        _iconRect.size.height = 36;
    }
    return self;
}

- (void)dealloc {
}

- (void)layoutSubviews {
    const CGSize size = self.bounds.size;
    
    _trackHeight = (NSInteger)(size.height - _iconRect.size.height + 0.5f);
    _iconRect.origin.x = size.width - _iconRect.size.width - 1.f;
    _iconRect.origin.y = (NSInteger)(_trackHeight * _value + 0.5f);
    
    if (_dragging) {
        _dragging = NO;
        [_delegate sliderWillEndDragging:self];
    }
    [_thumbView setFrame:_iconRect];
}

- (void)setValue:(CGFloat)value {
    if (!_dragging) {
        if (0.f > value) {
            _value = 0.f;
        } else if (1.f < value) {
            _value = 1.f;
        } else {
            _value = value;
        }
        
        _iconRect.origin.y = (NSInteger)(_trackHeight * _value + 0.5f);
        [_thumbView setFrame:_iconRect];
    }
}

- (void)moveIconToLocation:(const CGPoint)location {
    _iconRect.origin.y = location.y - _iconRect.size.height / 2.f;
    
    if (0.f > _iconRect.origin.y) {
        _iconRect.origin.y = 0.f;
    } else if (_trackHeight < _iconRect.origin.y) {
        _iconRect.origin.y = _trackHeight;
    } else {
        _iconRect.origin.y = (NSInteger)(_iconRect.origin.y + 0.5f);
    }
    _value = _iconRect.origin.y / _trackHeight;
    [_thumbView setFrame:_iconRect];
    [_delegate slider:self didChangeValue:_value];
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [touches anyObject];
    const CGPoint location = [touch locationInView:self];
    
    CGFloat lower = _iconRect.origin.y - 20;
    CGFloat upper = _iconRect.origin.y + 20;
    
    if (lower < 0) {
        upper += -lower;
    } else if (upper > _trackHeight) {
        lower -= (upper - _trackHeight);
    }
    upper += _iconRect.size.height;
    
    if (lower <= location.y && location.y <= upper) {
        _dragging = YES;
        [_delegate sliderDidBeginDragging:self];
    }
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [touches anyObject];
    const CGPoint location = [touch locationInView:self];
    
    if (_dragging) {
        [self moveIconToLocation:location];
    } else if (_iconRect.origin.y <= (location.y + 20.f) && (location.y - 20.f) <= (_iconRect.origin.y + _iconRect.size.height)) {
        _dragging = YES;
        [self moveIconToLocation:location];
    }
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    if (_dragging) {
        UITouch *touch = [touches anyObject];
        const CGPoint location = [touch locationInView:self];
        
        [_delegate sliderWillEndDragging:self];
        _dragging = NO;
        [self moveIconToLocation:location];
    }
}

- (void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event {
}

@end
