//
//  PSTextSettingsViewController.m
//  iFileReader
//
//  Created by LiDong on 13-4-10.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "PSTextSettingsViewController.h"
#import "PSFontSettingsViewController.h"
#import "PSFontSizeViewController.h"
#import "PSEncodingViewController.h"
#import "UITextStyleSettings.h"

#define kNumberOfSections 2

@interface PSTextSettingsViewController () {
    NSInteger _numberOfRows[kNumberOfSections];
    NSString *_sectionTitles[kNumberOfSections];
}

@end

@implementation PSTextSettingsViewController

- (id)initBasics {
    if (self = [super init]) {
        [self setTitle:LS(@"TXT_FILES")];
        
        _sectionTitles[0] = LS(@"FONT");
        _sectionTitles[1] = LS(@"DATA_INTERPRETATION");
        
        _numberOfRows[0] = 2;
        _numberOfRows[1] = 1;
        
        UIBarButtonItem *doneItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(onDone)];
        
        [[self navigationItem] setRightBarButtonItem:doneItem];
        UIBarButtonItem *flexibleItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:nil action:NULL];
        NSArray *toolbarItems = [[NSArray alloc] initWithObjects:flexibleItem, _rotationItem, nil];
        
        [self setToolbarItems:toolbarItems];
        }
    return self;
}

- (id)init {
    if (self = [self initBasics]) {
        _textStyle = [[UITextStyleSettings alloc] init];
    }
    return self;
}

- (id)initWithTextStyle:(UITextStyleSettings *)textStyle {
    if (self = [self initBasics]) {
        _textStyle = textStyle;
    }
    return self;
}

- (void)loadView {
    _tableView = [[UITableView alloc] initWithFrame:CGRectPortraitLongVC style:UITableViewStyleGrouped];
    [_tableView setDataSource:self];
    [_tableView setDelegate:self];
    [_tableView setRowHeight:44];
    
    [self setView:_tableView];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [_tableView reloadData];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    
    NSIndexPath *selectedIndexPath = [_tableView indexPathForSelectedRow];
    
    if (selectedIndexPath) {
        [_tableView deselectRowAtIndexPath:selectedIndexPath animated:YES];
    }
}

- (void)releaseSubviews {
    _tableView = nil;
}

- (void)dealloc {
    }

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	return kNumberOfSections;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	return _numberOfRows[section];
}


- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
	return _sectionTitles[section];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath  {
    UILabel *detailTextLabel = nil;
    const NSInteger section = [indexPath section];
    const NSInteger row = [indexPath row];
    NSString *CellIdentifier = [[NSString alloc] initWithFormat:@"Cell-%d-%d", section, row];
	UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
	
	if (nil == cell) {
		cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:CellIdentifier];
        [cell setSelectionStyle:UITableViewCellSelectionStyleGray];
        [cell setAccessoryType:UITableViewCellAccessoryDisclosureIndicator];
        
        NSString *text = nil;
        UILabel *textLabel = [cell textLabel];
        
        [textLabel setFont:UIFontBold16];
        detailTextLabel = [cell detailTextLabel];
        [detailTextLabel setBackgroundColor:UIColorClear];
        [detailTextLabel setFont:UIFontNormal14];
        
        if (0 == section) {
            if (0 == row) {
                text = LS(@"NAME");
            } else if (1 == row) {
                text = LS(@"SIZE");
            } else {
            }
        } else if (1 == section) {
            if (0 == row) {
                text = LS(@"ENCODING");
            }
        }
        
        [textLabel setText:text];
        
	} else {
        detailTextLabel = [cell detailTextLabel];
    }
    
    NSString *detailText = nil;
    
    if (0 == section) {
        if (0 == row) {
            [detailTextLabel setFont:[_textStyle fontForSubTitle]];
            detailText = [_textStyle fontDisplayName];
        } else if (1 == row) {
            detailText = [NSString stringWithFormat:@"%lu pt", [_textStyle fontSize]];
        } else {
        }
    } else if (1 == section) {
        if (0 == row) {
            detailText = UISettingsGetEncodingNameForCFStringEncoding([_textStyle encoding]);
        }
    }
    
    [detailTextLabel setText:detailText];
    
    return cell;
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    const NSInteger section = [indexPath section];
    const NSInteger row = [indexPath row];
    UIViewController *viewController = nil;
    
    if (0 == section) {
        if (0 == row) {
            viewController = [[PSFontSettingsViewController alloc] initWithTextStyle:_textStyle];
        } else {
            viewController = [[PSFontSizeViewController alloc] initWithTextStyle:_textStyle];
        }
    } else {
        viewController = [[PSEncodingViewController alloc] initWithTextStyle:_textStyle];
    }
    if (viewController) {
        [[self navigationController] pushViewController:viewController animated:YES];
        }
}

#pragma mark - Action

- (void)onHome {
    [[self navigationController] dismissViewControllerAnimated:YES completion:NULL];
}

- (void)onDone {
    [_textStyle save];
    [[self navigationController] dismissViewControllerAnimated:YES completion:NULL];
}

@end
