//package com.feasycom.feasybeacon.ui.about.suota.fragments;
//
//import static android.content.Context.INPUT_METHOD_SERVICE;
//
//import static com.feasycom.feasybeacon.ui.about.suota.activities.SuotaActivity.PARAMETER_SETTINGS_ID;
//
//import android.bluetooth.BluetoothDevice;
//import android.content.Context;
//import android.os.Bundle;
//import android.text.Editable;
//import android.text.TextUtils;
//import android.text.TextWatcher;
//import android.view.LayoutInflater;
//import android.view.View;
//import android.view.ViewGroup;
//import android.view.inputmethod.InputMethodManager;
//import android.widget.AdapterView;
//import android.widget.ArrayAdapter;
//import android.widget.Button;
//import android.widget.EditText;
//import android.widget.RadioGroup;
//import android.widget.Spinner;
//import android.widget.TextView;
//import android.widget.Toast;
//
//import androidx.annotation.NonNull;
//import androidx.annotation.Nullable;
//
//import com.dialog.suotalib.global.SuotaLibConfig;
//import com.dialog.suotalib.suota.SuotaFile;
//import com.feasycom.feasybeacon.R;
//
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.List;
//import java.util.regex.Matcher;
//import java.util.regex.Pattern;
//
//public class ParameterSettingFragment extends BaseSuotaFragment {
//
//    private TextView deviceNameTv;
//    private TextView fileNameTv;
//    private RadioGroup memoryRadioGroup;
//    private View spiSettingsWrapper;
//    private List<Spinner> gpioSpinners;
//    private RadioGroup imageBankRadioGroup;
//    private EditText blockSizeEt;
//    private Button sendButton;
//
//    // GPIO常量
//    public static final int MISO_GPIO_INDEX = 0;
//    public static final int MOSI_GPIO_INDEX = 1;
//    public static final int CS_GPIO_INDEX = 2;
//    public static final int SCK_GPIO_INDEX = 3;
//    public static final int SCL_GPIO_INDEX = 4;
//    public static final int SDA_GPIO_INDEX = 5;
//
//    // GPIO字符串模式
//    private static final Pattern gpioStringPattern = Pattern.compile("P(\\d+)_(\\d+)");
//
//    private final List<Integer> gpioDefaults = Arrays.asList(
//            SuotaLibConfig.Default.MISO_GPIO,
//            SuotaLibConfig.Default.MOSI_GPIO,
//            SuotaLibConfig.Default.CS_GPIO,
//            SuotaLibConfig.Default.SCK_GPIO);
//
//    // 选中的GPIO值
//    private List<Integer> gpioSelectedValues = new ArrayList<>(gpioDefaults);
//    private int selectedBlockSize = SuotaLibConfig.Default.BLOCK_SIZE;
//    private int selectedImageBank = SuotaLibConfig.Default.IMAGE_BANK;
//
//    private OnParameterSettingsFragmentInteractionListener mListener;
//
//    private String deviceName;
//    private String firmwareName;
//    private ArrayAdapter<CharSequence> gpioAdapter;
//
//    public static ParameterSettingFragment newInstance(String deviceName, String firmwareName) {
//        ParameterSettingFragment parameterSettingFragment = new ParameterSettingFragment();
//
//        Bundle args = new Bundle();
//
//        args.putString(BluetoothDevice.class.getSimpleName(), deviceName);
//
//        args.putString(SuotaFile.class.getSimpleName(), firmwareName);
//
//        parameterSettingFragment.setArguments(args);
//
//        return parameterSettingFragment;
//    }
//
//    // 从Bundle创建新实例
//    public static ParameterSettingFragment newInstance(Bundle bundle) {
//        ParameterSettingFragment parameterSettingFragment = new ParameterSettingFragment();
//        parameterSettingFragment.setArguments(bundle);
//        return parameterSettingFragment;
//    }
//
//    @Override
//    public void onCreate(@Nullable Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        if (getArguments() == null) return;
//        deviceName = getArguments().getString(BluetoothDevice.class.getSimpleName());
//        firmwareName = getArguments().getString(SuotaFile.class.getSimpleName());
//    }
//
//    @Override
//    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
//        baseListener.onSuotaFragmentIdentifierUpdate(PARAMETER_SETTINGS_ID);
//        return inflater.inflate(R.layout.fragment_parameter_setting, container, false);
//    }
//
//    @Override
//    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
//        // 初始化视图组件
//        // 通过视图 ID 查找和绑定视图组件
//
//        // 查找并绑定设备名称 TextView
//        deviceNameTv = view.findViewById(R.id.device_name_value);
//
//        // 查找并绑定文件名称 TextView
//        fileNameTv = view.findViewById(R.id.filename_value);
//
//        // 查找并绑定内存设置单选按钮组
//        memoryRadioGroup = view.findViewById(R.id.memory_radio_group);
//
//        // 查找并绑定 SPI 设置视图
//        spiSettingsWrapper = view.findViewById(R.id.spi_settings);
//
//        // 初始化 GPIO 选择器的列表
//        gpioSpinners = new ArrayList<>(4);
//        // 查找并绑定 MISO GPIO 选择器
//        gpioSpinners.add(view.findViewById(R.id.miso_gpio_spinner));
//        // 查找并绑定 MOSI GPIO 选择器
//        gpioSpinners.add(view.findViewById(R.id.mosi_gpio_spinner));
//        // 查找并绑定 CS GPIO 选择器
//        gpioSpinners.add(view.findViewById(R.id.cs_gpio_spinner));
//        // 查找并绑定 SCK GPIO 选择器
//        gpioSpinners.add(view.findViewById(R.id.sck_gpio_spinner));
//
//        // 查找并绑定图像库单选按钮组
//        imageBankRadioGroup = view.findViewById(R.id.image_bank_group);
//
//        // 查找并绑定块大小编辑文本
//        blockSizeEt = view.findViewById(R.id.block_size);
//
//        // 查找并绑定发送按钮
//        sendButton = view.findViewById(R.id.send);
//
//        // 初始化 GPIO 选择器的设置
//        initializeSpinners();
//
//        // 注册视图组件的事件监听器
//        registerListeners();
//
//        // 初始化设置值
//        initializeSettingValues();
//
//        // 恢复保存的状态
//        restoreState(getArguments());
//    }
//
//    private AdapterView.OnItemSelectedListener itemSelectedListener = new AdapterView.OnItemSelectedListener() {
//        @Override
//        public void onItemSelected(AdapterView<?> adapterView, View view, int position, long itemId) {
//            // 处理选择的GPIO值
//            String stringValue = adapterView.getSelectedItem().toString();
//            int value = gpioStringToInt(stringValue);
//            SharedPreferencesUtils.setPreviousInput(requireContext(), adapterView.getId(), stringValue);
//            int id = adapterView.getId();
//            if (id == R.id.miso_gpio_spinner) {
//                gpioSelectedValues.set(MISO_GPIO_INDEX, value);
//            } else if (id == R.id.mosi_gpio_spinner) {
//                gpioSelectedValues.set(MOSI_GPIO_INDEX, value);
//            } else if (id == R.id.cs_gpio_spinner) {
//                gpioSelectedValues.set(CS_GPIO_INDEX, value);
//            } else if (id == R.id.sck_gpio_spinner) {
//                gpioSelectedValues.set(SCK_GPIO_INDEX, value);
//            }
//        }
//
//        @Override
//        public void onNothingSelected(AdapterView<?> adapterView) {
//        }
//    };
//
//    private void registerListeners() {
//        // 注册内存类型选择监听器
//        memoryRadioGroup.setOnCheckedChangeListener((radioGroup, id) -> {
//            // 根据选中的单选按钮 ID 设置内存类型
//            if (id == R.id.spi_radio) {
//                setMemoryType(BeaconOtaProfile.Constants.MEMORY_TYPE_EXTERNAL_SPI);
//            }
//        });
//
//        // 注册图像银行选择监听器
//        imageBankRadioGroup.setOnCheckedChangeListener((radioGroup, id) -> {
//            // 根据选中的单选按钮 ID 设置图像银行
//            if (id == R.id.oldest_radio) {
//                setImageBank(0);
//            } else if (id == R.id.bank1_radio) {
//                setImageBank(1);
//            } else if (id == R.id.bank2_radio) {
//                setImageBank(2);
//            }
//        });
//
//        // 注册块大小文本框的文本变化监听器
//        blockSizeEt.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
//                // 在文本变化之前的操作，这里不需要任何操作
//            }
//
//            @Override
//            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
//                // 文本变化时的操作，这里不需要任何操作
//            }
//
//            @Override
//            public void afterTextChanged(Editable editable) {
//                int fileBlockSize;
//
//                try {
//                    // 尝试将块大小从文本中解析为整数
//                    fileBlockSize = Math.abs(Integer.parseInt(blockSizeEt.getText().toString()));
//                } catch (NumberFormatException nfe) {
//                    // 如果解析失败，设置块大小为 0
//                    fileBlockSize = 0;
//                }
//
//                // 如果块大小小于等于 0，设置错误提示
//                if (fileBlockSize <= 0) {
//                    blockSizeEt.setError("Invalid Block Size, must be greater than zero");
//                    return;
//                }
//
//                // 清除错误提示，并保存选中的块大小
//                blockSizeEt.setError(null);
//                selectedBlockSize = fileBlockSize;
//                // 保存之前的输入到 SharedPreferences
//                SharedPreferencesUtils.setPreviousInput(getActivity(), R.id.block_size, blockSizeEt.getText().toString());
//            }
//        });
//
//        // 注册 GPIO 选择器的监听器
//        for (int i = 0; i < gpioSpinners.size(); i++) {
//            // 设置每个 GPIO 选择器的项目选择监听器
//            gpioSpinners.get(i).setOnItemSelectedListener(itemSelectedListener);
//            // 设置每个 GPIO 选择器的触摸监听器，用于隐藏键盘
//            gpioSpinners.get(i).setOnTouchListener((view, motionEvent) -> {
//                hideKeyboard(); // 隐藏键盘
//                return false; // 返回 false 以允许其他操作继续进行
//            });
//        }
//
//        // 注册发送按钮的点击事件监听器
//        sendButton.setOnClickListener(view -> {
//            hideKeyboard(); // 隐藏键盘
//
//            // 如果块大小文本框有错误提示，则显示错误消息并返回
//            if (blockSizeEt.getError() != null && !TextUtils.isEmpty(blockSizeEt.getError().toString())) {
//                Toast.makeText(getActivity(), getString(R.string.invalid_block_size), Toast.LENGTH_SHORT).show();
//                return;
//            }
//
//            // 获取当前选中的内存类型单选按钮 ID
//            int id = memoryRadioGroup.getCheckedRadioButtonId();
//            // 如果选中的内存类型是 SPI，则触发 "发送到设备" 操作
//            if (id == R.id.spi_radio) {
//                mListener.onSendUpdateButtonClick(selectedBlockSize, gpioSelectedValues, selectedImageBank);
//            }
//        });
//    }
//
//    private void initializeSpinners() {
//        // 获取当前的上下文
//        Context context = getActivity();
//        // 如果上下文为空，直接返回
//        if (context == null) return;
//
//        // 创建一个 ArrayAdapter，用于为 GPIO 选择器提供数据
//        // 从资源中加载 GPIO 值数组，并设置布局为简单的下拉项布局
//        gpioAdapter = ArrayAdapter.createFromResource(
//                getActivity(),              // 当前活动的上下文
//                R.array.gpio_values,        // GPIO 值数组资源
//                android.R.layout.simple_spinner_item // 下拉项的布局
//        );
//        // 设置下拉列表的视图布局
//        gpioAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
//
//        // 为每个 GPIO 选择器设置适配器
//        // 遍历所有的 GPIO 选择器，并应用刚刚创建的适配器
//        for (Spinner spinner : gpioSpinners) {
//            spinner.setAdapter(gpioAdapter);
//        }
//    }
//
//    private void initializeSettingValues() {
//        // 初始化设置值
//
//        // 设置设备名称的显示文本。如果 deviceName 为 null，则显示默认信息
//        deviceNameTv.setText(deviceName != null ? deviceName : getString(R.string.no_info));
//
//        // 设置固件文件名的显示文本
//        fileNameTv.setText(firmwareName);
//
//        // 从 SharedPreferences 获取之前输入的块大小，如果没有，则使用默认值
//        String previousText = SharedPreferencesUtils.getPreviousInput(getActivity(), R.id.block_size);
//        blockSizeEt.setText(TextUtils.isEmpty(previousText) ? String.valueOf(BeaconOtaLibConfig.Default.BLOCK_SIZE) : previousText);
//
//        // 初始化 GPIO 选择器的选项
//        for (int i = 0; i < gpioSpinners.size(); i++) {
//            // 从 SharedPreferences 获取之前选择的 GPIO 值
//            int position = gpioAdapter.getPosition(SharedPreferencesUtils.getPreviousInput(getActivity(), gpioSpinners.get(i).getId()));
//            // 如果未找到先前的选择，则使用默认值
//            if (position == -1) {
//                position = gpioDefaults.get(i);
//            }
//            // 设置 GPIO 选择器的选中项
//            gpioSpinners.get(i).setSelection(position);
//        }
//
//        // 初始化内存类型选择
//        int previousMemoryType;
//        try {
//            // 从 SharedPreferences 获取之前选择的内存类型
//            previousMemoryType = Integer.parseInt(SharedPreferencesUtils.getPreviousInput(getActivity(), R.id.memory_radio_group));
//        } catch (NumberFormatException nfe) {
//            // 如果获取失败，则使用默认内存类型
//            previousMemoryType = BeaconOtaLibConfig.Default.MEMORY_TYPE;
//        }
//        // 设置内存类型，确保类型值有效
//        setMemoryType(previousMemoryType > 0 ? previousMemoryType : BeaconOtaLibConfig.Default.MEMORY_TYPE);
//
//        // 初始化图像银行选择
//        int previousImageBank;
//        try {
//            // 从 SharedPreferences 获取之前选择的图像银行
//            previousImageBank = Integer.parseInt(SharedPreferencesUtils.getPreviousInput(getActivity(), R.id.image_bank_group));
//        } catch (NumberFormatException nfe) {
//            // 如果获取失败，则使用默认图像银行
//            previousImageBank = BeaconOtaLibConfig.Default.IMAGE_BANK;
//        }
//        // 设置图像银行
//        setImageBank(previousImageBank);
//    }
//
//    private void setMemoryType(int memoryType) {
//        hideKeyboard();
//        SharedPreferencesUtils.setPreviousInput(getActivity(), R.id.memory_radio_group, String.valueOf(memoryType));
//        memoryRadioGroup.check(R.id.spi_radio);
//        spiSettingsWrapper.setVisibility(View.VISIBLE);
//    }
//
//    private void setImageBank(int imageBank) {
//        // 隐藏软键盘
//        hideKeyboard();
//
//        // 将选择的图像银行值保存到 SharedPreferences
//        SharedPreferencesUtils.setPreviousInput(getActivity(), R.id.image_bank_group, String.valueOf(imageBank));
//
//        // 根据传入的图像银行值选择相应的单选按钮
//        if (imageBank == BeaconOtaProfile.Constants.IMAGE_BANK_OLDEST) {
//            // 选择 "最旧的" 图像银行
//            imageBankRadioGroup.check(R.id.oldest_radio);
//            selectedImageBank = imageBank; // 更新选中的图像银行
//        } else if (imageBank == BeaconOtaProfile.Constants.IMAGE_BANK_1) {
//            // 选择 "银行1" 图像银行
//            imageBankRadioGroup.check(R.id.bank1_radio);
//            selectedImageBank = imageBank; // 更新选中的图像银行
//        } else if (imageBank == BeaconOtaProfile.Constants.IMAGE_BANK_2) {
//            // 选择 "银行2" 图像银行
//            imageBankRadioGroup.check(R.id.bank2_radio);
//            selectedImageBank = imageBank; // 更新选中的图像银行
//        }
//    }
//
//    private int gpioStringToInt(@NonNull String gpioValue) {
//        Matcher m = gpioStringPattern.matcher(gpioValue);
//        if (m.matches()) {
//            return ((Integer.decode(m.group(1)) & 0x0f) << 4) | (Integer.decode(m.group(2)) & 0x0f);
//        } else {
//            throw new IllegalArgumentException("Invalid GPIO string");
//        }
//    }
//
//    private void hideKeyboard() {
//        InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(INPUT_METHOD_SERVICE);
//        if (imm != null && imm.isAcceptingText() && getActivity().getCurrentFocus() != null)
//            imm.hideSoftInputFromWindow(getActivity().getCurrentFocus().getWindowToken(), 0);
//    }
//
//    @Override
//    public Bundle saveState() {
//        Bundle bundle = new Bundle();
//        bundle.putString(BluetoothDevice.class.getSimpleName(), deviceName);
//        bundle.putString(SuotaFile.class.getSimpleName(), firmwareName);
//        return bundle;
//    }
//
//    @Override
//    public void restoreState(Bundle bundle) {
//        // 实现恢复状态的方法（目前为空）
//    }
//
//    @Override
//    public void onAttach(Context context) {
//        super.onAttach(context);
//        if (context instanceof OnParameterSettingsFragmentInteractionListener) {
//            mListener = (OnParameterSettingsFragmentInteractionListener) context;
//        } else {
//            throw new RuntimeException(context.toString() + " must implement OnParameterSettingsFragmentInteractionListener");
//        }
//    }
//
//    @Override
//    public void onDetach() {
//        super.onDetach();
//        mListener = null;
//    }
//
//    public interface OnParameterSettingsFragmentInteractionListener {
//        void onSendUpdateButtonClick(int blockSize, List<Integer> gpioValues, int imageBank);
//    }
//}
