package com.feasycom.feasybeacon.ui.about.suota.global;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.SparseArray;

import androidx.annotation.NonNull;

import com.feasycom.feasybeacon.R;

/**
 * 用于操作SharedPreferences的工具类。
 */
public class SharedPreferencesUtils {

    // 资源ID到SharedPreferences键的映射
//    private static final SparseArray<String> prevInputPrefKeyMap = new SparseArray<>() {{
//        put(R.id.miso_gpio_spinner, "misoGpioSpinner");
//        put(R.id.mosi_gpio_spinner, "mosiGpioSpinner");
//        put(R.id.cs_gpio_spinner, "csGpioSpinner");
//        put(R.id.sck_gpio_spinner, "sckGpioSpinner");
//        put(R.id.image_bank_group, "imageBank");
//        put(R.id.block_size, "blockSize");
//        put(R.id.memory_radio_group, "memoryRadioGroup");
//        put(R.id.menu_show_bonded_devices, "show_bonded_devices");
//    }};

    private static SharedPreferences getPreferences(@NonNull Context context) {
        // 获取SharedPreferences对象
        return context.getSharedPreferences("settings", Context.MODE_PRIVATE);
    }

//    public static String getPreviousInput(@NonNull Context context, int resourceID) {
//        // 获取之前保存的输入值
//        String key = prevInputPrefKeyMap.get(resourceID);
//        return getPreferences(context).getString(key, null);
//    }

//    public static void setPreviousInput(@NonNull Context context, int resourceID, @NonNull String value) {
//        // 保存输入值
//        String key = prevInputPrefKeyMap.get(resourceID);
//        getPreferences(context).edit()
//                .putString(key, value.trim())
//                .apply();
//    }

    public static boolean fileDirectoriesCreated(@NonNull Context context) {
        // 检查文件目录是否已创建
        return getPreferences(context).getBoolean("fileDirectoriesCreated", false);
    }

    public static void setFileDirectoriesCreated(@NonNull Context context) {
        // 标记文件目录已创建
        getPreferences(context).edit()
                .putBoolean("fileDirectoriesCreated", true)
                .apply();
    }

    public static void setFirmwareDisplaySetting(@NonNull Context context, String key, boolean value) {
        // 设置固件显示设置
        getPreferences(context).edit()
                .putBoolean(key, value)
                .apply();
    }

    public static boolean getFirmwareDisplaySetting(@NonNull Context context, String key) {
        // 获取固件显示设置
        return getPreferences(context).getBoolean(key, true);
    }
}
